## Dynamic Hierarchy (Advanced)

Please refer to this [page](../../mdx_tutorial/dimensions.md) for a quick introduction of the dimension concept.

### Overview

Dynamic hierarchies allow you to dynamically create hierarchies based on the names of the dimension
table columns.

This is handy in scenarios where the columns of a table change, and you do not want to update
your schema accordingly. It can also be a way to have the same base schema for multiple clients,
where these columns represent custom attributes.

The fields available use regular expressions ([www](https://docs.oracle.com/javase/tutorial/essential/regex/)) to
define and filter.

### Walkthrough

We have two input tables :

`Books`

```
ID     Title        FolderName
1      Book A       Science
2      Book B       Science
3      Book C       Culinary arts
4      Book D       Culinary arts
```

`Book Attribute (dynamic)`

```
BID  FieldID  Value
1    Media    Medium
2    Media    Medium
3    Media    Amazon
4    Media    Amazon
1    Type     Article
2    Type     Article
3    Type     Book
4    Type     Book
1    Year     2000
2    Year     2010
3    Year     2020
```

Eventually, a [Java Transformation](../schemas_cubes/etl_java.md) will create the table in the structure we
want (`Media`, `Type` and `Year` are columns):

```
D    Title     FolderName     H:Type   H:Year    H:Media
1    Book A    Science        Article  2000      Medium
2    Book B    Science        Article  2010      Medium
3    Book C    Culinary arts  Book     2020      Amazon
4    Book D    Culinary arts  Book     2015      Amazon
```

Now we can create our `Books` dimension using dynamic hierarchies. For the sake of simplicity we will define 3 fields :

- _Is New Hierarchy_ : `\H:.*`    , columns starting with H: define a hierarchy
- _Hierarchy Name_   : `\H:(.*)`  , take the text after H: as hierarchy name
- _All Member Name_  : `All $HierarchyName`

![Dynamic Hierarchies Dimension example](./img/walk-dim-dynamichierarchies-1.png)

Browsing the dimension results in a dimension defined as expected :

![Dynamic Hierarchies Dimension browse](./img/walk-dim-dynamichierarchies-2.png)

### Download

The schema of this example is available for download [here](data/Walkthrough_DynamicHierarchies.zip).

Next chapter: [Parent/Child](dim_parentchild.md).

_
