## Data Sources

Data sources are the actual sources of raw data from which cubes (i.e. facts and dimensions) are built.

### Data Source Agnostic

The icCube server is data source agnostic, meaning that when building the cubes it does not rely on
any specific type of data source. Currently usable data sources include files, Excel files, relational databases,
NoSql, Google (Sheets, Analytics, Big-Query), In-Memory tables and data streams (e.g. HTTP).

### User-Defined Data Sources

You may easily add new types of data sources thanks to the icCube plugin framework if needed. You can find more
details in the following [chapter](../plugins_extensions/plugins_extensions.md).

### Schema - Data Source Relationship

There's no limit to the actual number of data sources that can be used when creating a schema. In fact, a schema
may be built mixing different types of data sources. For example, one possible approach could be to source some data
from several Excel sheets and also from one or more external text files.

Next chapter: [Relational Database](ds_database.md) details how to use a relational databases as data sources.

_