## XMLA Service

Assuming the server is running on the local machine with default configuration, the XMLA service
over HTTP is available (unless mentioned otherwise) at the following address:

```
http://localhost:8282/icCube/xmla
```

The XMLA connector is used by reporting tools (e.g., [Excel](../integration/excel.md) pivot table) and API (Analysis
Services [AdomdClient](../integration/ssas_adomdclient.md)). More details can be found in
the [reporting tools integration](../integration/integration.md) page.

### Authentication

Note that when the XMLA endpoint and the Web dashboards are used in completely **different scenarios**, they are more
likely requiring different authentications. This might not be possible when using icCube in a standalone deployment
but remember that when embedding icCube, the actual authentication is left up to the host application. The most
simple way of embedding icCube is by placing it **behind an HTTP proxy**; this proxy can then perform any required
authentication (based on the actual target URL) and forward to icCube the authorization information. See this 
[page](../../../devops/Embedded.md) for more details.

### Limitations

Although we have made every effort to make the XMLA connector as much as possible compatible with several existing
tools and API, there are still several features that have not yet been implemented. If you encounter any limitations
or need assistance, please don’t hesitate to [reach out](https://www.iccube.com/contact-us/) to us.
We're here to help!

Next chapter: [Startup Sequence](startup.md).

_
