## Windows Service

### NSSM

[NSSM](http://nssm.cc/) can be used to turn the `icCube.bat` into a Windows Service.

```
Download <a href="http://nssm.cc/">NSSM</a>. Make sure to choose the 64-bit or 32-bit version of NSSM
to match the architecture of your Windows installation.

Save nssm.exe to a folder of your choice. You'll need to keep NSSM in
this folder in order for the service to function.

Open a command prompt as admin and "cd" to the folder containing NSSM.

Type "nssm install" to open the NSSM user interface.
```

Follow this [guide](http://nssm.cc/usage) to create your Windows Service. The Application path is the path
of the installed `icCube.bat` file. You can leave the default Startup directory.

In the Details tab, choose the name of the service that will be used later for service management.
You can add a Display name and its description.

When pressing the Install service button the service should be installed. It is visible in the Windows
Services manager under the name chosen in the previous step. There you can start/stop the service.

`Wrapping the JVM`

For more flexibility, instead of wrapping the `icCube.bat` you can instead wrap directly the JVM exe,
configuring it to launch the icCube main class (see `icCube.bat` content) and any other JVM parameter 
(e.g., memory). Doing this way allows for separating and keeping easily the configuration files apart 
from the binary installation.

For example, you could put in a single place the following files:

```
D:/MySolution
    /dev
        /bin                - directory with a few files for launching icCube and custom configuration
        /data               - this is the fileSystemRoot as seen from icCube (e.g., for CSV files)
        /license            - license file
        /plugins            - user specific plugins
```

and then create a service using the NSSM UI as following:

```
Application:

    Path
            C:\Program Files\icCube\8.1.1\jre64\bin\java.exe
    Startup directory
            C:\Program Files\icCube\8.1.1\bin
    Arguments
            -Xmx2g -DicCube.install="C:\Program Files\icCube\8.1.1" -cp "C:\Program Files\icCube\8.1.1\lib\*" crazydev.iccube.server.IcCubeServer

Environment (referencing the D:/MySolution configurations):

    ICCUBE_CONFIGURATION=D:/MySolution/dev/bin/icCube.xml
    ICCUBE_LOG4J_CONFIGURATION=D:/MySolution/dev/bin/log4j.xml
    ICCUBE_LICENSE=D:/MySolution/dev/license/icCube-4.lic
```

Since icCube 8.2, you can use JAVA system properties instead of environment variables.
See this [page](../configuring_iccube/jre_options.md) for more details.

Next chapter : [Network Access](network_endpoints.md).

_
