## Migrating icCube : 8.6.2 to 9.0.0

**IMPORTANT** : icCube 9.0 is a major release so please review carefully **all the following points** to ensure
your existing production environment can be properly migrated. You need to remove several deprecated configurations 
from your existing `icCube.xml` file first before starting icCube 9.0. In case of any doubt, please contact us for
more information and/or help.

**IMPORTANT** : If you're migrating from a version earlier than **8.4.0**, your dashboards won't be available
as 9.0 does not migrate automatically the content of the Docs repository from a very old format. So please,
migrate first to 8.4.0.

**IMPORTANT** : Dashboards : the icCube server 9.0 requires the **Dashboards application 9.0**.

**IMPORTANT** : Dashboards : the dashboards API code from 8.6.2 that was tagged `deprecated` has been removed.
If you use deprecated code in your own plugin, first migrate to the new methods suggested by its docstring.

**IMPORTANT** : Dashboards : v7. The icCube server 9.0 does not support anymore the **Reporting v7**.

### Java 25

Java 25 is being required to run icCube.

### Java Classpath

The `/plugins` folder has been added to the Java classpath in the `icCube.sh` file. Please update your own startup 
file accordingly. 

Note that in case you have an additional plugin folder defined in `icCube.xml` : 

```
<additionalPlugins value="/opt/ic3/add-plugins"/>
```

you'll have to update the Java classpath as well. Using the default `icCube.sh`,  this can be done using the 
`ICCUBE_JAVA_CP` environment variable. For example when starting from a Docker : 

```
docker -e ICCUBE_JAVA_CP="/opt/ic3/add-plugins/*" ...
```

### Jetty HTTP Server Migration

The embedded Jetty HTTP server has been migrated to its latest version (i.e., 12.x).

The following `icCube.xml` **configuration** sections have been changed :

`httpComponentConfiguration`

This section contains an optional `Cross Origin Handler` configuration (moved from the `filters` section) :

```
<!--
    Optional Jetty Cross Origin Handler
-->
<!--
        <crossOriginConfiguration>

            <allowCredentials>false</allowCredentials>
            <allowedHeaders>Content-Type</allowedHeaders>
            <allowedMethods>GET,POST,HEAD</allowedMethods>
            <allowedOriginPatterns></allowedOriginPatterns>
            <allowedTimingOriginPatterns></allowedTimingOriginPatterns>
            <deliverPreflightRequests>false</deliverPreflightRequests>
            <deliverNonAllowedOriginRequests>true</deliverNonAllowedOriginRequests>
            <deliverNonAllowedOriginWebSocketUpgradeRequests>false</deliverNonAllowedOriginWebSocketUpgradeRequests>
            <exposedHeaders></exposedHeaders>
            <preflightMaxAge>60</preflightMaxAge>

        </crossOriginConfiguration>
-->
```

`webApp`

In this section, the names of the properties have changed from :

```
org.eclipse.jetty.servlet.*
```

to

```
org.eclipse.jetty.session.*
```

Should you have any **authentication/authorization Java plugin**, you might need to recompile them to take
into account the new `jakarta.*` namespace replacing the `javax.*` one. For your information, icCube is now
building with the following dependency :

```
api("jakarta.servlet:jakarta.servlet-api:6.1.0")
```

### Facts Indexing

icCube 9.0 is using a new format for the facts index. This means the format of the **schema backups** has changed.
We advise re-generating any existing backups. Note that for the sake of simplicity, an existing backup can be
loaded but an automatic migration is being performed that is increasing the loading time.

The **maximum size** of the facts index for a given hierarchy is `4g`. Should you need more, you can activate
table or level partitioning for that facts.

### Facts Index in Files

The "Facts in Files" configuration properties in `icCube.xml` have been removed : `factsColumnFileSize`,
`factsColumnFileBufferSize`, `factsColumnBufferSize`. They were either deprecated and/or not used.

The "Index and Facts in Files" feature is back. The following configuration properties in `icCube.xml` have been
removed : `indexFileSize`, `indexFileBufferSize`, `indexBufferSize`, `factsIndexFileSize`, `factsIndexFileBufferSize`,
`factsIndexBufferSize`. They were either deprecated and/or not used.

Note that the deprecated "Index in Files" option has been removed.

### MDX Evaluation

Review the new `NON EMPTY` crossjoin configuration (`icCube.xml : mdxEvalConfiguration : neCj...`) for
improved performance (parallel execution, cache, etc...).

### MDX Java Integration

Accessing Java methods using the notation `J!Package.Class.Method( ...)` has been removed. Use native function
instead. Please contact us for more information and/or help.

### MDX R Integration

Support for Renjin has been removed. Please contact us for more information and/or help.

### Schema Builder ETL Transformation

The Geo coder view has been removed.

### Data Sources

The deprecated Google Analytics datasource has been removed. Use Google Analytics v4 instead.

JDBC connections are now created with `setAutocommit(false)` to fix Postgres|Redshift memory usage.
In case of issue with this, there is a new `Advanced` property in the definition of each JDBC datasource
to switch off this behavior.

### Deprecated Features Removal

The following previously deprecated features have been removed. Please contact us for more information and/or help.

`# icCube.xml : directories.mdxQueriesDirectory`

This folder configuration does not exist anymore and any previously existing MDX queries have to be manually
migrated and/or moved into the Docs repository.

`# icCube.xml : directories.gviServiceDirectory`

This folder configuration does not exist anymore.

`# icCube.xml : gviServices`

This configuration does not exist anymore.

`# icCube.xml : docsRepositoryDB`

This configuration does not exist anymore.

`# icCube.xml : resultCacheConfiguration.rDataSource`

This configuration does not exist anymore.

`# icCube.xml : olapEngineComponentConfiguration.javascriptViewConfiguration`

This configuration does not exist anymore.

`# icCube.xml : javaMdxConfiguration.classRepositoryActive|classRepositoryPath|allowedPackage|Class|Method`

This configuration does not exist anymore.

`# icCube.xml : reportingComponentConfiguration.discussions`

This configuration does not exist anymore.

`# icCube.xml : printComponentConfiguration.printInBrowserUrl|houseKeepingPeriod|paperSizes.fix`

This configuration does not exist anymore.

`# icCube.xml : javaMdxNativeConfiguration.permissions`

This configuration does not exist anymore.

`# icCube.xml : javaViewConfiguration.permissions`

This configuration does not exist anymore.

`# Docs: docsRepository/ic3-report`

This Docs folder is not migrated anymore. Please migrate first to 8.4.0 before migrating to 9.0 if you'd like
to have the content of this folder in your 9.0 installation.

`# REST API : ExecuteMdxScript`

This deprecated REST API request has been removed : use `TidyExecuteMdxScript` instead.

`# Reporting v7`

The icCube server 9.0 does not support anymore the **Reporting v7**. Contact us for more information.

As a side effect of this removal, the following properties have been removed.

```
icCubeProperties:report.viz.enabled
icCubeProperties:report.v8.enabled
icCubeProperties:report.pivotTable.colWidth.auto
icCubeProperties:report.pivotTable.topHeader.wrap
```        

_