## NGINX (Web Server) & icCube

icCube is following J2EE standards (e.g., servlets) and as such can be setup to work with any web server.
This page is explaining how to setup NGINX and icCube for a typical production environment.

### NGINX Configuration Overview

We need to configure NGINX to act as a reverse proxy forwarding all the requests to icCube and authenticating
the users (java servlet reverse proxy). Connections between NGINX and icCube are then considered as trusted,
leaving to icCube the task to authorize the users. Here is an extract of the configuration file (no HTTPS)
assuming icCube is running on the localhost in the 8282 port:

Create a new file in the `conf.d` NGINX directory (e.g., `iccubeapp.conf`) with the following content

```
server {

   listen 80;
   listen [::]:80;

   server_name yourwebserver.com;

   client_max_body_size 0;  # no size limit for the downloads (i.e backup files might be large)

   location / {
        proxy_pass http://localhost:8282/;  #local icCube server
        proxy_set_header X-Real-IP       $remote_addr;
        proxy_set_header Host            $host;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    }
}
```

Once the configuration file has been changed you can check it :

```
sudo nginx -t
```

If everything is fine you can restart NGINX:

```
sudo nginx -s reload
```

### Installing HTTPS with certbot

Thanks to `certbot` tool installing an HTTPS certificate is an easy task. You can follow instructions
from certbot web page on this [link](https://certbot.eff.org/instructions) (no need to install snap,
`sudo apt install certbot python-certbot-nginx`).

Once certbot installed in your OS you have to run

```
 sudo certbot --nginx
```

Follow the instructions, `certbot` is going to install the required certificates and modify your NGINX configuration.
The end result is going to look like :

```
server {

   server_name yourwebserver.com;

   client_max_body_size 0;  # no size limit for the downloads (i.e backup files might be large)

   location / {
     proxy_pass http://localhost:8282/;   #local icCube server
     proxy_set_header X-Real-IP       $remote_addr;
     proxy_set_header Host            $host;
     proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
   }

    listen [::]:443 ssl ipv6only=on; # managed by Certbot
    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/yourwebserver.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/yourwebserver.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot

}
server {
    if ($host = yourwebserver.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


   listen 80;
   listen [::]:80;

   server_name dev.iccube.com;
    return 404; # managed by Certbot


}
```

Next chapter : [Memory (RAM) Configuration](ram.md) describes several options to configure the RAM usage with icCube.

_
