## Configuration File : icCube.xml

The file `$install/bin/icCube.xml` contains the configuration properties of the icCube server.
The file shipped with icCube describes all the possible configuration settings and is visible
via the `Admin / Configuration / icCube.xml` page.

### Java System Properties

A Java system property may be used to define a configuration.

For example, the following string :

    ${http.port:-8282}      or  ${sys:http.port:-8282} 

will be replaced by the value of the `http.port` variable or `8282` if the variable is not defined.

### Environment Variables

Environment variables can be used wherever a Java system property can be used.

For example, the following string :

    ${env:SERVER:-localhost}

will be replaced by the value of the `SERVER` variable or `localhost` if the variable is not defined.

### Content

Here is the content of the `icCube.xml` file as shipped for **icCube 8.4.8**. Please refer to your actual
installation file to get an up-to-date version : 

```xml
<?xml version="1.0" encoding="UTF-8"?>

<!--
  ~ Copyright 2014 - 2017 icCube Software Llc.
  ~
  ~ The code and all underlying concepts and data models are owned fully
  ~ and exclusively by icCube Software Llc. and are protected by
  ~ copyright law and international treaties.
  ~
  ~ Warning: Unauthorized reproduction, use or distribution of this
  ~ program, concepts, documentation and data models, or any portion of
  ~ it, may result in severe civil and criminal penalties, and will be
  ~ prosecuted to the maximum extent possible under the law.
  -->
<icCubeConfiguration xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                     xsi:noNamespaceSchemaLocation="https://downloads.iccube.com/schemas/icCubeConfiguration.xsd">

    <!--
        icCube Server Configuration

        Online doc. : https://doc.iccube.com/?ic3topic=server.user_guide.configuring_iccube.iccube_xml

        Note that when mentioned, a Java system property may be used to define a configuration.
        Please refer to each section for more details.

        For example ${user.home} is replaced by the value of the Java system property named: user.home
        
        Since v8.4.13, environment variables can be used wherever a Java system property can be used.

            ${user.home}       refers to the Java system property user.home        
            ${sys:user.home}   refers to the Java system property user.home        
            ${env:USER}        refers to the environment variable USER
            
            ${name:-default}   allows for defining a default value if the property/variable is not defined.        
    -->

    <!--
        Some sort of unique server id (currently used in the notification service
        to identify the server using that configuration file).
    -->
    <id/>

    <!--
        An optional icCube environment description: this will add a banner in the UI displaying
        the name of the environment. The color can be any HTML CSS color. Predefined named colors
        are:

        white, silver, gray, black, red, maroon, yellow, olive, lime,
        green, aqua, teal, blue, navy, fuchsia, purple.
    -->
    <!--<environment name="PROD" color="red"/>-->

    <!--
        icCube Application Directories

        These directories represent a running icCube instance. Several instance of icCube servers
        may run on the same machine provided each instance is using a different set of directories.

        On the very first startup of icCube, the content of this directories may be setup using
        the content of the icCube install directories (e.g., plugins, examples of schemas/cubes).

        JAVA system properties may be used to defined directories.
    -->
    <directories>

        <!--
            The icCube main application directory.
        -->
        <dataDirectory value="${user.home}/icCube-data"/>

        <!--
            icCube temporary files.
        -->
        <tmpDirectory value="${icCube.directories.dataDirectory}/tmp"/>

        <!--
            icCube repository containing audit (aka. monitoring) information.
        -->
        <auditDirectory value="${icCube.directories.dataDirectory}/audit"/>

        <!--
            icCube deployed schemas and cubes definitions repository.
        -->
        <cubesDirectory value="${icCube.directories.dataDirectory}/cubes"/>

        <!--
            icCube (on-demand) generated offline data cubes repository.
        -->
        <offlineDirectory value="${icCube.directories.dataDirectory}/offline"/>

        <!--
            icCube schema data : e.g., facts files.
        -->
        <schemaDataDirectory value="${icCube.directories.dataDirectory}/schemaData"/>

        <!--
            icCube edited schema and cubes definitions repository.
        -->
        <builderDirectory value="${icCube.directories.dataDirectory}/builder"/>

        <!--
            icCube MDX OAuth2 authorizations repository.
        -->
        <oauth2Directory value="${icCube.directories.dataDirectory}/oauth2"/>

        <!--
            icCube roles repository.
        -->
        <rolesDirectory value="${icCube.directories.dataDirectory}/roles"/>

        <!--
            icCube users repository.
        -->
        <usersDirectory value="${icCube.directories.dataDirectory}/users"/>

        <!--
            icCube users repository.
        -->
        <tenantsDirectory value="${icCube.directories.dataDirectory}/tenants"/>

        <!--
            icCube public file repository.

            The content of this directory is public (not authentication required)
            as opposed to the JCR repository (see below).

            E.g., an easy way to store reporting resources.
        -->
        <webPubDirectory value="${icCube.directories.dataDirectory}/webPub"/>

        <!--
            icCube Docs repository

            Currently used for the reporting application. Documents within this repository
            are accessible through access rights according to the user roles.
        -->
        <docsRepositoryDirectory value="${icCube.directories.dataDirectory}/docsRepository"/>

        <!--
            icCube scheduler definition (e.g., load schema jobs).
        -->
        <schedulerDirectory value="${icCube.directories.dataDirectory}/scheduler"/>

        <!--
            icCube schema backups.
        -->
        <backupDirectory value="${icCube.directories.dataDirectory}/backup"/>

        <!--
            icCube multi-tenant directory : contains one directory for each tenant.

            Each tenant directory will in turn contain dedicated:

                docsRepositoryDirectory,
                cubesDirectory,
                etc...
        -->
        <multiTenantDirectory value="${icCube.directories.dataDirectory}/tenantsData"/>

    </directories>

    <!--
        An optional section that allows for configuring the ' Init Parameters ' of Jetty.
    -->
    <webApp>

        <!--
            An example showing how to change the name of the JSESSIONID cookie; handy for example
            when having icCube part of a complex Web App (e.g., behind a proxy).
        -->
        <!--
                <context-param>
                    <param-name>org.eclipse.jetty.session.SessionCookie</param-name>
                    <param-value>IC3_JSESSIONID</param-value>
                </context-param>

                <context-param>
                    <param-name>org.eclipse.jetty.session.SessionIdPathParameterName</param-name>
                    <param-value>ic3_jsessionid</param-value>
                </context-param>
        -->

        <!--
            icCube specific (optional) parameter to setup the HttpOnly flag for the session cookie.

            Default: true (since icCube 7.3: was false before).
        -->
        <context-param>
            <param-name>org.eclipse.jetty.session.SessionCookie.httpOnly</param-name>
            <param-value>true</param-value>
        </context-param>

        <!--
            icCube specific (optional) parameter to setup the SameSite flag for the session cookie.

            Possible values are:

                NONE    : this requires the Secure flag as well (not possible w/ HTTP).
                STRICT
                LAX
        -->
        <!--
                <context-param>
                    <param-name>org.eclipse.jetty.session.SessionCookie.sameSite</param-name>
                    <param-value>NONE</param-value>
                </context-param>
        -->
        <!--
            icCube specific (optional) parameter to setup the Secure flag for the session cookie.
            Required for example with SameSite=None.
        -->
        <!--
                <context-param>
                    <param-name>org.eclipse.jetty.session.SessionCookie.secure</param-name>
                    <param-value>true</param-value>
                </context-param>
        -->

    </webApp>

    <!--
        (Optional) HTTP Configuration (required for XMLA over HTTP, UX and GVI support)
    -->
    <httpComponentConfiguration>

        <!--
            Jetty 9 thread pool : -1 means default value (200).
        -->
        <serverThreadMax>-1</serverThreadMax>
        <!--
            Jetty 9 thread pool : -1 means default value (8).
        -->
        <serverThreadMin>-1</serverThreadMin>
        <!--
            Jetty 9 thread pool : -1 means default value (60000) - millis.
        -->
        <serverThreadIdleTimeout>-1</serverThreadIdleTimeout>

        <!--
            Jetty 9 thread pool : -1 means default value (threadMin).
        -->
        <serverQueueCapacity>-1</serverQueueCapacity>
        <!--
            Jetty 9 thread pool : -1 means default value (threadMin).
        -->
        <serverQueueGrowBy>-1</serverQueueGrowBy>
        <!--
            Jetty 9 thread pool : -1 means default value (Integer.MAX_VALUE).

            By default, the queue is unbounded. As a result, under high load (in excess of the processing power)
            Jetty will keep a lot of requests on the queue. Even after the load has stopped, Jetty will appear
            to have stopped responding to new requests as it still has lots of requests on the queue to handle.

            For a high reliability system, it should reject the excess requests immediately (fail fast) by using
            a queue with a bounded capability. The capability (maximum queue length) should be calculated according
            to the "no-response" time tolerable. For example, if icCube can handle 100 requests per second, and
            if you can allow it one minute to recover from excessive high load, you can set the queue capability
            to 60 * 100 = 6000. If it is set too low, it will reject requests too soon and can't handle normal
            load spike.
        -->
        <serverQueueMaxCapacity>-1</serverQueueMaxCapacity>

        <!--
            -1 means the HTTP connector is not activated.
        -->
        <portNumber>8282</portNumber>

        <!--
            Optional; an empty hostname (or IP address) means listening on all network interfaces.
        -->
        <hostName/>

        <!--
            Allows for compressing HTTP responses.
        -->
        <enableCompression>true</enableCompression>

        <!--
            Larger headers will allow for more and/or larger cookies plus larger form content encoded
            in a URL. However, larger headers consume more memory and can make a server more vulnerable
            to denial of service attacks.

            Number of bytes: -1 means default value (8*1024)
        -->
        <requestHeaderSize>-1</requestHeaderSize>

        <!--
            Larger headers will allow for more and/or larger cookies and longer HTTP headers (eg for redirection).
            However, larger headers will also consume more memory.

            Number of bytes: -1 means default value (8*1024)
        -->
        <responseHeaderSize>-1</responseHeaderSize>

        <!--
            Set the size of the buffer into which response content is aggregated before being sent
            to the client.  A larger buffer can improve performance by allowing a content producer
            to run without blocking, however larger buffers consume more memory and may induce some
            latency before a client starts processing the content.

            Number of bytes: -1 means default value (32*1024)
        -->
        <outputBufferSize>-1</outputBufferSize>

        <!--
            Number of bytes: -1 means default value (currently : 200000)
            Equivalent to the JAVA system property : org.eclipse.jetty.server.Request.maxFormContentSize

            E.g., the Web Reporting application save reports and export to Excel
            might generate quite large form content.
        -->
        <maxFormContentSize>524288</maxFormContentSize>

        <!--
            HTTP session timeout in seconds (-1 means no timeout)
        -->
        <sessionTimeout>36000</sessionTimeout>

        <!--
            JETTY connection timeout in seconds (-1 means default : 30s).
        -->
        <idleTimeout>-1</idleTimeout>

        <!--
            -1 means the SSL (i.e., HTTPS) connector is not activated.
            A JAVA system property maybe used.
        -->
        <sslPortNumber>-1</sslPortNumber>

        <!--
            An optional path to the key store when using the SSL connector.
            (not relevant if SSL port number = -1)
        -->
        <sslKeyStorePath/>

        <!--
            See Jetty documentation to generate an OBF: value

                https://jetty.org/docs/jetty/12/operations-guide/tools/index.html

            If not specified, the value will be prompted on the console.

            (not relevant if SSL port number = -1)
        -->
        <sslKeyStorePassword/>

        <!--
            Defaulted to JKS (others JCEKS, PKCS12, ...).

            (not relevant if SSL port number = -1)
        -->
        <sslKeyStoreType/>

        <!--
            The keyManagerPassword is passed as the password arg to KeyManagerFactory.init(...). If there is no
            keyManagerPassword, then the keyStorePassword is used instead. If there is no trustManager set, then
            the keystore is used as the trust store and the keyStorePassword is used as the trustStore password.
        -->
        <sslKeyManagerPassword/>

        <!--
            Same configuration as the key store.
        -->
        <sslTrustStorePath/>

        <!--
            Same configuration as the key store.
        -->
        <sslTrustStorePassword/>

        <!--
            Same configuration as the key store.
        -->
        <sslTrustStoreType/>

        <!--
            Comma separated list.
        -->
        <includeCipherSuites/>

        <!--
            Comma separated list.
        -->
        <excludeCipherSuites/>

        <!--
            Optional Jetty ForwardedRequestCustomizer (refer to Jetty configuration).
        -->
        <!--
                <forwardedRequestConfiguration>
                    <forwardedOnly>...</forwardedOnly>
                    <proxyAsAuthority>...</proxyAsAuthority>
                    <forwardedHeader>...</forwardedHeader>
                    <forwardedHostHeader>...</forwardedHostHeader>
                    <forwardedServerHeader>...</forwardedServerHeader>
                    <forwardedProtoHeader>...</forwardedProtoHeader>
                    <forwardedForHeader>...</forwardedForHeader>
                    <forwardedHttpsHeader>...</forwardedHttpsHeader>
                    <forwardedSslSessionIdHeader>...</forwardedSslSessionIdHeader>
                    <forwardedCipherSuiteHeader>...</forwardedCipherSuiteHeader>
                </forwardedRequestConfiguration>
        -->

        <!--
            Optional Jetty Cross Origin Handler
        -->
        <!--
                <crossOriginConfiguration>

                    <allowCredentials>false</allowCredentials>
                    <allowedHeaders>Content-Type</allowedHeaders>
                    <allowedMethods>GET,POST,HEAD</allowedMethods>
                    <allowedOriginPatterns></allowedOriginPatterns>
                    <allowedTimingOriginPatterns></allowedTimingOriginPatterns>
                    <deliverPreflightRequests>false</deliverPreflightRequests>
                    <deliverNonAllowedOriginRequests>true</deliverNonAllowedOriginRequests>
                    <deliverNonAllowedOriginWebSocketUpgradeRequests>false</deliverNonAllowedOriginWebSocketUpgradeRequests>
                    <exposedHeaders></exposedHeaders>
                    <preflightMaxAge>60</preflightMaxAge>

                </crossOriginConfiguration>
        -->
        
    </httpComponentConfiguration>

    <!--
        (Optional) XMLA Configuration
    -->
    <xmlaComponentConfiguration>

        <!--
            XMLA - the HTTP port number (from the HTTP configuration) is used.

            Report Portal :
                is using the URL to determine capabilities of the XMLA provider (e.g., multi-hierarchy support).
                => configure Report Portal *** client *** with /icCube/xmla?msmdpump.dll
                => confirm still required in 3.0 ?

            JPivot :
                has hardcoded XMLA provider detection
                => configure JPivot *** client *** with /icCube/xmla?jpivot
        -->
        <httpUrl>/icCube/xmla</httpUrl>

        <!-- <filter>White List</filter> -->
        <filter>HTTP Basic Authentication</filter>

        <!--
            Setup of Windows SSO (comment out the referenced filters in the filterConfiguration section).
        -->
        <!--
                <filter>Windows SSO (Waffle)</filter>
                <filter>Windows SSO (adapter)</filter>
        -->

    </xmlaComponentConfiguration>

    <!--
        (optional) icCube UI : admin, builder, ...
    -->
    <uxComponentConfiguration>

        <!--
            The (optional) static part is serving /icCube/console static HTTP resources.
        -->
        <static>

            <param>
                <name>cacheControl</name>
                <value>public, max-age=31536000</value>
            </param>

            <!-- <filter>White List</filter> -->
            <filter>HTTP Form Authentication</filter>

        </static>

        <!--
            The (optional) api part is serving /icCube/ux-api JSON/HTTP requests from the UI interface.
            Required if the <static> part has been activated.
        -->
        <ux-api>

            <!-- <filter>White List</filter> -->
            <filter>UX API Default Authentication</filter>

            <!--
                By default, icCube is protecting against CSRF attack. This parameters allows
                for deactivating this protection. Default value: false.
            -->
            <csrfOff>false</csrfOff>;

        </ux-api>

        <!--
            The (optional) REST JSON API api (outside UI context) : /icCube/api
        -->
        <api>

            <!-- <filter>White List</filter> -->
            <filter>Rest API X-AUTHORIZATION</filter>

        </api>

    </uxComponentConfiguration>

    <!--
        (Optional) Report Configuration (UI server side)
    -->
    <reportingComponentConfiguration>

        <!--
            (Optional) The type of the app-local configuration file.

                    JSON5 :  app-local/ic3report-config.json5   (Content-Security-Policy compliant)
                    JS    :  app-local/ic3report-config.js      (default)
        -->
        <configurationType>JSON5</configurationType>

        <url>/icCube/doc/*</url>
        <url>/icCube/report/*</url>

        <!--
            (Optional) HTTP headers added to the Reporting Application documents.
        -->
        <app-headers>

            <app-header>
                <app-header-name>Cache-Control</app-header-name>
                <app-header-value>public, max-age=31536000</app-header-value>
            </app-header>

        </app-headers>

        <!-- <filter>White List</filter> -->
        <filter>HTTP Form Authentication</filter>

        <!--
            Setup of Windows SSO (comment out the referenced filters in the filterConfiguration section).
        -->
        <!--
                <filter>Windows SSO (Waffle)</filter>
                <filter>Windows SSO (adapter)</filter>
        -->

    </reportingComponentConfiguration>

    <!--
        (Optional) Google Visualization Data Source.
    -->
    <gviComponentConfiguration>

        <url>/icCube/gvi</url>

        <!--
            By default, icCube is protecting against CSRF attack. This parameters allows
            for deactivating this protection. Default value: false.
        -->
        <csrfOff>false</csrfOff>;

        <!-- <filter>White List</filter> -->
        <filter>GVI Request Authentication</filter>
        <filter>GVI Authentication (logout)</filter>

        <!--
            Setup of Windows SSO (comment out the referenced filters in the filterConfiguration section).
        -->
        <!--
                <filter>Windows SSO (Waffle)</filter>
                <filter>Windows SSO (adapter)</filter>

                <filter>GVI Authentication (logout)</filter>
        -->

    </gviComponentConfiguration>

    <!--
        (Optional) Print Server configuration : the 'active' attribute allows for de-activating
        that configuration (the print on-server will not be started in that case - in browser
        still active).
    -->
    <printComponentConfiguration active="false">

        <url>/icCube/print/*</url>

        <!--
            (Optional) When activated assert the connections (from Chrome / wkhtmltopdf) are from this address.

            Values:

                ignore     : no assert

                localhost  : assert from localhost

                ip-address : assert connections are from the specified address

            Default behavior: assert connections from localhost.
        -->
        <filterParam>
            <name>assertFromLocalhost</name>
            <value>localhost</value>
        </filterParam>

        <!--
            Chrome/Chromium: icCube is attempting to locate Chrome in the system.

            To prevent that lookup, you can define the exec property to reference the absolute path
            of the executable to launch. The optional execOptions define extra command line arguments
            for Chrome/Chromium process.
        -->
        <!--<exec>chromium</exec>-->
        <!--<execOptions></execOptions>-->

        <!--
            Handy if multi IP machine ( full URL: http://icCube-address:xxx/icCube/print/ )
            or when printing with icCube/Chrome in Docker image(s).
        -->
        <printUrl/>

        <!--
            (Seconds) Elapsed time after which a printing job is considered as timed out (can be
            cancelled by the housekeeping job.
        -->
        <timeout>30</timeout>

        <!--
            (Milliseconds) Period to check for Chrome headless status (in case you get an error
            'Cannot find context with specified id' try increasing this).
        -->
        <waitPeriodMS>500</waitPeriodMS>

        <!--
            (Milliseconds) Timeout used while waiting for Chrome headless response (e.g., printToPDF).
            Default: 120'000ms (i.e., 2min)
        -->
        <readingTimeoutMS>120000</readingTimeoutMS>

        <!--
            Maximum number of active printing jobs within icCube.

            Once this limit has been reached, incoming printing jobs are blocked until
            one or more being active printing jobs have been fully processed.

            Default: 4
        -->
        <maxActiveCount>4</maxActiveCount>

        <!--
            Paper sizes are sent to the Reporting application for printing purpose.

            Each paper can define its own margin used in the Dashboard application when converting
            desktop like widget layout to a given paper size.
        -->
        <paperSizes>

            <paperSize name="A5"
                       unit="mm"
                       width="148"
                       height="210"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="A4"
                       unit="mm"
                       width="210"
                       height="297"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="A3"
                       unit="mm"
                       width="297"
                       height="420"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="B5"
                       unit="mm"
                       width="176"
                       height="250"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="B4"
                       unit="mm"
                       width="250"
                       height="353"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="JIS-B5"
                       unit="mm"
                       width="182"
                       height="257"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="JIS-B4"
                       unit="mm"
                       width="257"
                       height="364"
                       marginTop="10"
                       marginBottom="10"
                       marginLeft="10"
                       marginRight="10"/>

            <paperSize name="Letter"
                       unit="in"
                       width="8.5"
                       height="11"
                       marginTop=".5"
                       marginBottom=".5"
                       marginLeft=".5"
                       marginRight=".5"/>

            <paperSize name="Legal"
                       unit="in"
                       width="8.5"
                       height="14"
                       marginTop=".5"
                       marginBottom=".5"
                       marginLeft=".5"
                       marginRight=".5"/>

            <paperSize name="Ledger"
                       unit="in"
                       width="11"
                       height="17"
                       marginTop=".5"
                       marginBottom=".5"
                       marginLeft=".5"
                       marginRight=".5"/>

        </paperSizes>

    </printComponentConfiguration>

    <!--
        The list of filters being used by the components.
        Each component can use a chain of filters.
    -->
    <filterConfiguration>

        <!--
            GVI : extracting the username, password from the GVI request parameters.
        -->
        <filter>
            <filter-name>GVI Request Authentication</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeGviRequestAuthenticationServletFilter</filter-class>
            <init-param>
                <!--
                    You can as well remove the role 'anonymous' from the server if you do not need it at all
                    via the Monitoring/Roles application or rolesDirectory/roles.icc-roles files.
                -->
                <param-name>anonymousLogon</param-name>
                <param-value>true</param-value>
            </init-param>
        </filter>

        <!--
            GVI : handle logout request
        -->
        <filter>
            <filter-name>GVI Authentication (logout)</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeGviLogoutAuthenticationServletFilter</filter-class>
        </filter>

        <!--
            HTTP Form Authentication.
        -->
        <filter>
            <filter-name>HTTP Form Authentication</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeFormAuthenticationServletFilter</filter-class>

            <init-param>
                <!--
                    You can as well remove the role 'anonymous' from the server if you do not need it at all
                    via the Monitoring/Roles application or rolesDirectory/roles.icc-roles files.
                -->
                <param-name>anonymousLogon</param-name>
                <param-value>true</param-value>
            </init-param>

            <!--
                        <init-param>
                            &lt;!&ndash;
                                If the URL contains the ic3demo parameter, the authentication is performed
                                with the user as defined by the param-value (no password is being requested).
                            &ndash;&gt;
                            <param-name>ic3demo</param-name>
                            <param-value>demo</param-value>
                        </init-param>
            -->

            <!--
                Optional path of the login HTML page (default: icCube install directory : web/icCube/icCube_login.html)

                A JAVA system property can be used as well as icCube directories properties:

                    ${user.home}/login.html
                    ${icCube.directories.webPubDirectory}/login.html

            -->
            <!--
                        <init-param>
                            <param-name>loginPage</param-name>
                            <param-value>${icCube.directories.webPubDirectory}/login.html</param-value>
                        </init-param>
            -->
        </filter>

        <!--
            HTTP Basic Authentication filter.
        -->
        <filter>
            <filter-name>HTTP Basic Authentication</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeBasicAuthenticationServletFilter</filter-class>
            <init-param>
                <param-name>realm</param-name>
                <param-value>icCube</param-value>
            </init-param>
            <init-param>
                <!--
                    You can as well remove the role 'anonymous' from the server if you do not need it at all
                    via the Monitoring/Roles application or rolesDirectory/roles.icc-roles files.

                    Note about Excel / ADOMD.NET : when anonymous is activated it is taking precedence over
                    for example the username/password defined in Excel. To connect with a username/password
                    you must de-activate the anonymous logon.
                -->
                <param-name>anonymousLogon</param-name>
                <param-value>true</param-value>
            </init-param>
        </filter>

        <!--
            UX API Default Authentication ( /icCube/ux-api ) : assert the user has been authenticated already.
        -->
        <filter>
            <filter-name>UX API Default Authentication</filter-name>
            <filter-class>crazydev.iccube.ux.processor.servlet.UxApiDefaultAuthenticationServletFilter</filter-class>
        </filter>

        <!--
            icCube is using credentials from Apache that is configured with HTTP Basic Authentication
        -->
        <!--
                <filter>
                    <filter-name>Apache Authentication</filter-name>
                    <filter-class>crazydev.iccube.server.authentication.IcCubeApacheAuthenticationServletFilter</filter-class>
                </filter>
        -->

        <!--
            Windows Integrated Authentication (SSO)
        -->
        <!--
                <filter>
                    <filter-name>Windows SSO (Waffle)</filter-name>
                    <filter-class>waffle.servlet.NegotiateSecurityFilter</filter-class>
                    <init-param>
                        <param-name>principalFormat</param-name>
                        <param-value>fqn</param-value>
                    </init-param>
                    <init-param>
                        <param-name>roleFormat</param-name>
                        <param-value>both</param-value>
                    </init-param>
                    <init-param>
                        <param-name>allowGuestLogin</param-name>
                        <param-value>false</param-value>
                    </init-param>
                    <init-param>
                        <param-name>securityFilterProviders</param-name>
                        <param-value>waffle.servlet.spi.NegotiateSecurityFilterProvider</param-value>
                    </init-param>
                    <init-param>
                        <param-name>waffle.servlet.spi.NegotiateSecurityFilterProvider/protocols</param-name>
                        <param-value>Negotiate NTLM</param-value>
                    </init-param>
                </filter>
        -->

        <!--
            Windows Integrated Authentication (SSO) : icCube adapter.

            Adapts the principal as provided by the NegotiateSecurityFilter into an icCube principal.
            Must follow the NegotiateSecurityFilter within the filter chain.

            - ignoreDomainInPrincipal : allows for creating icCube users without their domain names
            - domainPrincipalSplitter : a JAVA regular expression
        -->
        <!--
                <filter>
                    <filter-name>Windows SSO (adapter)</filter-name>
                    <filter-class>crazydev.iccube.server.authentication.IcCubeWindowsSSOAuthenticationServletFilter</filter-class>
                    <init-param>
                        <param-name>ignoreDomainInPrincipal</param-name>
                        <param-value>true</param-value>
                    </init-param>
                    <init-param>
                        <param-name>domainPrincipalSplitter</param-name>
                        <param-value>\\</param-value>
                    </init-param>
                </filter>
        -->

        <!--
            Rest API authentication filter.

            Using the X-AUTHORIZATION header that is containing the same information
            as the HTTP Basic Authentication.
        -->
        <filter>
            <filter-name>Rest API X-AUTHORIZATION</filter-name>
            <filter-class>crazydev.iccube.server.authentication.restapi.IcCubeRestApiXAuthorizationAuthenticationServletFilter</filter-class>
            <init-param>
                <!--
                    You can as well remove the role 'anonymous' from the server if you do not need it at all
                    via the Monitoring/Roles application or rolesDirectory/roles.icc-roles files.
                -->
                <param-name>anonymousLogon</param-name>
                <param-value>true</param-value>
            </init-param>
        </filter>

        <!--
            White List.

            Accept connections from specified IP addresses only. Handy to add an extra security
            layer when icCube is placed behind a reverse proxy for example.

                addresses: a comma separated list of authorized IP addresses. When specified
                           any connection from other addresses will be refused.
                           ( => ServletRequest.getRemoteAdr() ).
        -->
        <!--
        <filter>
            <filter-name>White List</filter-name>
            <filter-class>crazydev.iccube.server.authentication.IcCubeWhiteListFilter</filter-class>
            <init-param>
                <param-name>addresses</param-name>
                <param-value>127.0.0.1,0:0:0:0:0:0:0:1,::1,</param-value>
            </init-param>
        </filter>
        -->

    </filterConfiguration>

    <!--

        A dedicated job is running every periodS seconds to check if any cancelling request is still running.
        If a request is still cancelling after timeoutS seconds then it is dumped into a separate log file for
        postmortem analysis (default file: icCube-cancel-request.log).

    -->
    <cancellingRequestConfiguration active="true">

        <periodS>60</periodS>
        <timeoutS>30</timeoutS>

    </cancellingRequestConfiguration>

    <!--

        A dedicated job is running every periodS seconds to check if any running request has exceeded its
        authorized amount of time (i.e., timeout of its MDX evaluation profile). In that case, the requests
        are cancelled on timeout.

    -->
    <timeoutRequestConfiguration active="true">

        <periodS>10</periodS>

    </timeoutRequestConfiguration>

    <!--
        OLAP Engine Configuration
    -->
    <olapEngineComponentConfiguration>

        <olapProperties>

            <!--
                Maximum number of simultaneous requests within the OLAP engine. Pay attention
                that setting this value too low might queue incoming requests.

                -1 means Math.max(2, number of cores)
            -->
            <icCube.olapEngineSimultaneousRequestCount value="-1"/>

            <!--
                Maximum number of active schema LOAD requests. Once this limit has been
                reached incoming LOAD requests are blocked ( -1 means no limit ).
            -->
            <icCube.activeLoadCount value="2"/>

            <!--
                LOAD requests are split into READING & PROCESSING tasks. The tasks are processed
                simultaneously using a pool of threads. This property defines the maximum number
                of threads used for the READING tasks (e.g., file access, JDBC result set access).

                This configuration applies for each LOAD request (i.e., if 2 LOAD requests are
                active then the actual number of threads is : 2 * loadReadingThreadCount).

                -1 means number of cores, 0 means sequential processing.
            -->
            <icCube.loadReadingThreadCount value="2"/>

            <!--
                A LOAD request is split into several READING tasks to be processed by the pool
                of threads as described above. This value defines the maximum number of queued
                tasks. Once this limit has been reached, the generation of the tasks is being
                blocked preventing too much memory usage.

                Relevant if loadReadingThreadCount is not sequential.
            -->
            <icCube.loadReadingQueueSize value="32"/>

            <!--
                This value describe the number of rows each READING task (as described above)
                contains.

                Relevant if loadReadingThreadCount is not sequential.
            -->
            <icCube.loadReadingRowBatch value="1000"/>

            <!--
                LOAD requests are split into READING & PROCESSING tasks. The tasks are processed
                simultaneously using a pool of threads. This property defines the maximum number
                of threads used for the PROCESSING tasks (e.g., file access, JDBC result set access).

                This configuration applies for each LOAD request (i.e., if 2 LOAD requests are
                active then the actual number of threads is : 2 * loadProcessingThreadCount).

                -1 means number of cores, 0 means sequential processing.
            -->
            <icCube.loadProcessingThreadCount value="2"/>

            <!--
                A LOAD request is split into several PROCESSING tasks to be processed by the pool
                of threads as described above. This value defines the maximum number of queued
                tasks (per LOADING task). Once this limit has been reached, the generation of the
                tasks is being blocked preventing too much memory usage.

                Relevant if loadProcessingThreadCount is not sequential.
            -->
            <icCube.loadProcessingQueueSize value="32"/>

            <!--
                Optional configuration that controls how the facts are built. Disabling the
                build of the facts allows to test the datasource speed.

                Values: NONE | FULL

                Default: FULL
            -->
            <icCube.loadProcessingFactsMode value="FULL"/>

            <!--
                Optional configuration that controls the size of the LRU cache used
                to resolve members while processing the facts.

                Default: 2048.
            -->
            <icCube.factsResolveMemberLruCacheSize value="2048"/>

            <!--
                Dimension data (e.g., name, key, property) are stored into memory using
                list of buffers. This property determines the size in bytes of these buffers.

                buffer-size-bytes = 2 ^ icCube.dimMemBufferSize

                For example, 20 means the buffer size in bytes is 2^20 = 1'048'576 bytes (e.g., 1M).
            -->
            <icCube.dimMemBufferSize value="15"/>


            <!--
                Facts data are stored into memory using list of buffers. This property determines
                the size in bytes of these buffers.

                buffer-size-bytes = 2 ^ icCube.dimMemBufferSize

                For example, 15 means the buffer size in bytes is 2^15 = 32768 bytes ( 32K ).
            -->
            <icCube.factMemBufferSize value="15"/>

            <!--
                DEPRECATED: see icCube.factsColumnFileSize

                Option : Facts in File

                See : property directories.schemaDataDirectory above

                Each measure is stored within one or more files. This property determines the
                maximum size in bytes of each of these file (-1 means unlimited : a single file
                will be used for each measure). You might need to limit the maximum size because
                of the underlying operating system (e.g., 32 bits). The file size is computed as
                following:

                file-size-bytes = 2 ^ icCube.factFile.fileSize

                For example, icCube.factFile.fileSize = 30 means the file size in bytes is
                2 ^ 30 = 1'073'741'824 bytes (i.e., 1G).
            -->
            <icCube.factFileSize value="-1"/>

            <!--
                DEPRECATED: see icCube.factsColumnFileBufferSize

                Option : Facts in File

                See : property directories.schemaDataDirectory above

                Each measure is stored within one or more files that are then accessed via
                buffers. This property determines the size in bytes of these buffers. Note
                that the size of the files is a number of times the size of these buffers.
                The buffer size is computed as following :

                buffer-size-bytes = 2 ^ icCube.factFile.bufferSize

                For example, icCube.factFile.bufferSize = 20 means the buffer size in bytes is
                2 ^ 20 = 1'048'576 bytes (e.g., 1M).
            -->
            <icCube.factFileBufferSize value="20"/>

            <!--
                (Windows only) fact files cleaner running in the background.

                See : property directories.schemaDataDirectory above

                This property allows for enabling or disabling it in case of issue with the system.
                This is not recommended to disable it as temporary fact files won't be deleted while
                the icCube server is up and running. Note that these files are deleted each time the
                icCube server is started.
            -->
            <icCube.cleanerActive value="true"/>

            <!--
                (Windows only) fact files cleaner running in the background.

                See : property directories.schemaDataDirectory above

                This property determines the delay in seconds between each run.
            -->
            <icCube.cleanerDelay value="30"/>

            <!--
                (Windows only) fact files cleaner running in the background.

                See : property directories.schemaDataDirectory above

                This property determines the maximum number of files being deleted during each run
                (-1 means no limit - all files available for deletion are tried).
            -->
            <icCube.cleanerFileCount value="-1"/>

            <icCube.maxBufferSizeForCachingIterator value="65536"/>

            <icCube.duplicatedSolveOrderError value="false"/>

            <icCube.excelFixDotMembers value="true"/>

            <icCube.excelFixFilterHelperSet value="true"/>

            <icCube.excelFixXsdLong value="true"/>

            <icCube.calcMemberMaxEvaluationFrameStackSize value="128"/>

            <!--
                When true, the unique name of the calc. measure/member is the full name used for its declaration
                (i.e., not internally generated).
            -->
            <icCube.calcMemberDefinedUniqueName value="false"/>

            <icCube.functionMaxEvaluationFrameStackSize value="128"/>

            <icCube.mdxEvalUnknownMemberError value="true"/>

            <icCube.toStrMaxSize value="4096"/>

            <!--
                SystemDefault : default JVM locale of the server (0x0800)
                http://msdn.microsoft.com/en-us/library/dd318693%28VS.85%29.aspx
                https://doc.iccube.com/?ic3topic=server.mdx.icCubeLanguages
            -->
            <icCube.localeIdentifier value="2048"/>

            <icCube.visualMode value="NON_VISUAL_TOTAL"/>

            <icCube.visualTotalsIntermediateMembers value="true"/>

            <!--
                Maximum number of rows returned by a DRILLTHROUGH statement when its MAXROWS is not specified.
            -->
            <icCube.drillthroughDefaultMaxRows value="1000"/>

            <!--
                When activated wraps each sub-select axis expression into a CompactSet function call.
            -->
            <icCube.compactSetInSubSelect value="true"/>

            <!--
                Standard MDX does not allow a tuple to contain several members of the same hierarchy.
                This property relax this condition during the evaluation of axis, calculated members,
                and set formula.

                Standard MDX : true.
            -->
            <icCube.dimensionalityCheck value="false"/>

            <!--
                MDX cell property FORMAT_STRING syntax (either JAVA or EXCEL).

                The JAVA string format syntax is assumed when this icCube property is not defined.

                Note that using a prefix within the FORMAT_STRING will enforce a given syntax
                whatever the actual definition of this icCube property:

                    FORMAT_STRING = "e: ... " : enforce EXCEL format.
                    FORMAT_STRING = "j: ... " : enforce JAVA format.

                See the public documentation for more details : https://doc.iccube.com/?ic3topic=server.mdx.cellProperties.FORMAT_STRING
            -->
            <icCube.defaultFormatStringSyntax value="EXCEL"/>

            <!--
                Maximum number of table partitions (-1 means no limit);
                a few number of partitions is typically expected.
            -->
            <icCube.maxTablePartitionCount value="1024"/>

            <!--
                Maximum number of unresolved rows per facts table to keep in memory for processing during the next
                incremental load. If that maximum amount is reached an error is generated.
            -->
            <icCube.maxUnresolvedRowsCount value="65535"/>

            <!--
                Activate fast processing of NON EMPTY axes (defaulted to true).
                E.g., select NON EMPTY [Time].[Calendar].members on 0 from ...
            -->
            <icCube.mdxEvalFastNonEmptyAxis value="true"/>

            <!--
                Activate fast processing when several [Measures] are specified on an axis (defaulted to true).
                E.g., select [Measures].members on 0 from ...
            -->
            <icCube.mdxEvalMeasureVector value="true"/>

            <!--
                Minimum size of the set to activate fast set calculators in TopCount() like function.
            -->
            <icCube.mdxEvalSetCalculatorMinSize value="10"/>

            <!--
                Lambda functions (e.g., TopCount( { set }, N, lambda-expression ) ) can be processed using
                different modes for performance reason. This property allows for activating SET_CALC
                and PARALLEL_AXIS modes.

                Defaulted to: SET_CALC | PARALLEL_AXIS.

                Available values (as a mask) are:

                NONE          :  0
                SET_CALC      :  1    ( use of a faster set-evaluator when possible )
                PARALLEL_AXIS :  2    ( parallel processing of the set being iterated )

                An integer value can be used as well. E.g., 3 is the same as SET_CALC | PARALLEL_AXIS.
            -->
            <icCube.mdxEvalLambdaProcessingMode value="SET_CALC | PARALLEL_AXIS"/>

            <!--
                Maximum number of tuples being cached (per MDX query).
            -->
            <icCube.mdxQueryCacheMax value="1000000"/>

            <!--
                Maximum number of tuples being cached (per MDX query cell).
            -->
            <icCube.mdxQueryCellCacheMax value="1000000"/>

            <!--
                Calculated members can be cached (per MDX query). This property defines the type of cache.

                NONE      : the cache is not activated.

                ALL       : all calc. members are cached (see REQUEST_CACHED cell property for fine tuning).

                ON_DEMAND : use REQUEST_CACHED cell property to explicitly cache calculated members.

            -->
            <icCube.mdxQueryCalcMemberCacheMode value="ON_DEMAND"/>

            <!--
                Maximum number of calculated members being cached per MDX query.
            -->
            <icCube.mdxQueryCalcMemberCacheMax value="1000000"/>

            <!--
                This property controls how the NON EMPTY BEHAVIOR is setup.

                MANUAL    : calc. member NON EMPTY BEHAVIOR must be tbe setup explicitly.

                AUTO      : calc. member NON EMPTY BEHAVIOR is setup automatically if not defined.
            -->
            <icCube.nonEmptyBehaviorSetupMode value="AUTO"/>

            <!--
                This property defines the maximum number of vector items sent in the
                FORMATTED_VALUE of the pivot table cells (GVI).

                Default: 128.
            -->
            <icCube.pivotTableCellVectorFValueGviSize value="128"/>

            <!--
                This property defines the default name of the hierarchy all level.
            -->
            <icCube.defaultHierarchyAllLevelName value="All-Level"/>

            <!--
                This property defines the default name of the hierarchy all member.
            -->
            <icCube.defaultHierarchyAllMemberName value="All"/>

        </olapProperties>

        <!--
            Schema backup configuration.
        -->
        <backupConfiguration active="true">

            <!--
                The backup is using several files to persist the schema. Each of this files is by default
                unlimited in size. But for 32 bits OS you need to limit the maximum size because of the OS
                limitation (e.g., 2G).

                      -1 means no size limit.

                E.g., 2G, 1.5g, 64M, 64m, 64K, 64k, 64B, 64b

            -->
            <maxFileSize>-1</maxFileSize>

            <!--
                Size of the disk buffer used when writing the backup.

                Same format as maxFileSize and -1 means default value.

                Default value is 8K.
            -->
            <outBufferSize>-1</outBufferSize>

            <!--
                Size of the disk buffer used when reading the backup.

                Same format as maxFileSize and -1 means default value.

                Default value is 8K.
            -->
            <inBufferSize>-1</inBufferSize>

            <!--
                Compression method:

                     LZ4
                            LZ4 compression is used. The compression block size can be specified
                            as following:

                                LZ4:64K

                            The default block size is 1M.

                     NONE

                            No compression performed.

            -->
            <compression>LZ4</compression>

            <!--
                Optional.

                    KEEP

                            Default value.

                    DISCARD

                            Once a partition is re-loaded its previous load data is deleted from the backup.
            -->
            <loadPartitionHistory>KEEP</loadPartitionHistory>

            <!--
                Optional.

                    KEEP

                            Default value.

                    DISCARD

                            Once a backup is successfully created delete any previous existing backup.
            -->
            <backupHistory>KEEP</backupHistory>

        </backupConfiguration>

        <!--
            MDX evaluation configuration (i.e., physical resources allocation).
        -->
        <mdxEvalConfiguration>

            <!--
                Maximum number of active MDX requests within icCube.

                Once this limit has been reached, incoming MDX requests are blocked until
                one or more being executed requests have been fully processed.
            -->
            <activeMdxRequestCount>8</activeMdxRequestCount>

            <!--
                A list of profiles.

                MDX requests are processed via one or more MDX executors which are defined via profile.
                One of this profile has to be defined as the _ default _ profile.


                XML Attributes

                name     : must be unique within the list of profiles.

                forkMode : controls how many instances of the executor are started. Possible values are:

                            SERVER  : one instance for the whole server

                            ROLE    : one instance per role   ( shared by all tenants/users if not specified otherwise )
                            TENANT  : one instance per tenant ( shared by all users if not specified otherwise )
                            USER    : one instance per user

                default  : that executor is the one used when no other one can be determined.


                XML Elements

                activeMdxRequestCount : An optional value that is controlling the maximum number of active requests
                                        for all the executor instances of that profile.

                materializedSetTupleCount : Maximum number of tuples in materialized sets.

                                        The list of tuples of the sets created via the CREATE/WITH SET statements
                                        are materialized once evaluated for the first time. This value limits the
                                        length of such sets: an error is thrown if the sets are too large.

                                        -1 means no limitation.  Default: 10'000'000.

                tidyMaterializedAxisTupleCount : Maximum number of tuples in materialized axis (for Dashboards app).

                                        When an axis need to be materialized, this value limit the number of tuples.
                                        If the NON EMPTY keyword is specified for the axis, then this limit applies
                                        before the NON EMPTY processing.

                                        -1 means no limitation.  Default: 1'000'000.

                tidyRowCount          : Maximum number of rows returned by a SELECT statement (for Dashboards app).

                                        If the SELECT specifies NON EMPTY axes then this is the maximum numbers
                                        of non-empty rows.

                                        When the maximum number is reached the processing of the processing of
                                        the MDX statement is stopped and the result is being truncated.

                                        -1 means no limitation.  Default: 1'000'000.

                tidyColumnCount       : Maximum number of columns returned by a SELECT statement (for Dashboards app).
                                        Each tuple of the axis 0 generates one column.

                                        When the maximum number is reached the processing of the processing of
                                        the MDX statement is throwing an error.

                                        -1 means no limitation.  Default: 1'000.

                tidyCellCount         : Maximum number of cells returned by a SELECT statement (for Dashboards app).

                                        If the SELECT specifies NON EMPTY axes then this is the maximum numbers
                                        of non-empty cells.

                                        When the maximum number is reached the processing of the processing of
                                        the MDX statement is stopped and the result is being truncated. This value
                                        is actually limiting the number of rows. That is, the actual:

                                        max-row-count = min( tidyRowCount, tidyCellCount / cells-column-count)

                                        where cells-column-count : the number of tuples on the axis 0.
                                        where tidyRowCount       : min( server-tidyRowCount, reporting-tidyRowCount )

                                        -1 means no limitation.  Default: 1'000'000.

                tidyCellCountNE       : Used instead of tidyCellCount during the NON EMPTY processing when more than
                                        one MDX axis containing the NON EMPTY keyword. This is used to compute the
                                        cells before the NON EMPTY is actually applied. Once compute, tidyCellCount
                                        is used to generate the actual result with NON EMPTY being applied.

                cellCount             : Maximum number of cells returned by a SELECT statement. If the SELECT specifies
                                        NON EMPTY axes then this is the maximum numbers of non-empty cells.

                                        When the maximum number is reached the processing of the processing of the MDX
                                        statement is stopped and returns an error.

                                        -1 means no limitation.

                timeout               : The maximum number of seconds a MDX can be processed before a timeout error
                                        is generated.

                                        -1 means no timeout.

                threadCount           : An MDX request is being processed using a pool of threads.
                                        This property defines the maximum number of threads in this pool.

                                        -1 means number of cores, 0 means sequential processing.

                queueSize             : An MDX request is split into several cell tasks to be processed by the pool
                                        of threads (as described above). This value defines the maximum number of queued
                                        tasks. Once this limit has been reached, the generation of the tasks is being
                                        blocked preventing too much memory usage + saturating the executor with a single
                                        MDX request.

                extraThreadCount      : MDX requests might require additional parallel processing on top of the cell
                                        parallel processing as described in above. This property defines the number
                                        of threads allowed for this extra processing.

                                        E.g, TopCount, BottomCount, ...

                                        -1 means number of cores, 0 means sequential processing.

                extraQueueSize        : Similar semantic as for the queueSize property describe above that applies
                                        to the MDX extra. processing.


            -->
            <profile name="global-executor" forkMode="SERVER" default="true">

                <materializedSetTupleCount>10000000</materializedSetTupleCount>

                <tidyMaterializedAxisTupleCount>1000000</tidyMaterializedAxisTupleCount>
                <tidyRowCount>1000000</tidyRowCount>
                <tidyColumnCount>1000</tidyColumnCount>
                <tidyCellCount>1000000</tidyCellCount>
                <tidyCellCountNE>10000000</tidyCellCountNE>

                <cellCount>-1</cellCount>
                <timeout>3600</timeout>

                <threadCount>-1</threadCount>
                <queueSize>256</queueSize>

                <extraThreadCount>-1</extraThreadCount>
                <extraQueueSize>32</extraQueueSize>

            </profile>

            <!--
                An example of profile for self BI users limiting CPU usage.

                - this profile is limiting the number of thread available for MDX processing to 1.
                - one instance of executor is shared by all users of the same role (forkMode).
                - a maximum of 2 active requests for self BI users is allowed.

                This profile is selected (see selector below) for all users whose role name
                is starting with self-bi.
            -->
            <!--
                        <profile name="self-bi" forkMode="ROLE">

                            <activeMdxRequestCount>2</activeMdxRequestCount>

                            <cellCount>-1</cellCount>
                            <timeout>3600</timeout>

                            <threadCount>1</threadCount>
                            <extraThreadCount>1</extraThreadCount>

                        </profile>
            -->

            <!--
                An optional list of selectors.

                A selector determines which executor profile to use when executing an MDX request
                based on the user, tenant, or role of the request.

                If no executor can be found then the 'default' one is being use.

                    role   : define the executor to use for the defined role(s).
                    tenant : define the executor to use for the defined tenant(s).
                    user   : define the executor to use for the defined user(s).

                Wildcards (as JAVA regular expression) are allowed within role, tenant and user definitions.
            -->

            <!--
                        <selector profile="self-bi" for="role:self-bi-.*"/>
            -->

        </mdxEvalConfiguration>

        <!--
            MDX result are serialized either in RAM or in file before being sent back to the client applications.

            When not specified, the default configuration (FILE, LZ4) is being used.
        -->
        <resultSerializationConfiguration>

            <!--
                FILE   : results are serialized into the icCube-data/tmp directory.
                MEMORY : results are serialized into RAM (take care with large table results).
            -->
            <mode>FILE</mode>

            <!--
                NONE : no compression
                LZ4  : LZ4 is fast - expect 50% compression.
                ZIP  : slower than LZ4 - expect better compression ratio.
            -->
            <compression>LZ4</compression>

        </resultSerializationConfiguration>

        <!--
            MDX result cache.
        -->
        <resultCacheConfiguration>

            <!--
                Activates the MDX request result cache (case sensitive):

                MEMORY : the cache is activated and is memory based (faster).

                FILE   : the cache is activated and is file based.

                OFF    : the cache is not activated.
            -->
            <mode>MEMORY</mode>

            <!--
                MDX request result cache size (MB).
            -->
            <size>16</size>

            <!--
                Whether or not the MDX requests via GVI (i.e., Web Reporting) protocol are cached.
            -->
            <gvi>true</gvi>

            <!--
                Whether or not the MDX requests via XMLA protocol are cached.
            -->
            <xmla>true</xmla>

            <!--
                Whether or not the ALERT MDX statements are cached.
            -->
            <alerts>true</alerts>

            <!--
                The policy that determines if a MDX request can be cached.
            -->
            <cachingPolicy>

                <!--
                    The name of a class (IOlapResultCachePolicy) that determines if a MDX request can be cached.
                -->

                <!--
                    MDX request are cached after their first execution.
                -->
                <!--<classname>crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheImmediatePolicy</classname>-->

                <!--
                    MDX request that are executed twice are cached.
                -->
                <classname>crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheBufferedPolicy</classname>

                <!--
                    Number of MDX request being kept to determine if executed twice.
                -->
                <param>
                    <name>bufferedRequestCount</name>
                    <value>1024</value>
                </param>

            </cachingPolicy>

        </resultCacheConfiguration>

        <!--
            (Optional) Access to JAVA methods from MDX statement (i.e., -> notation).
        -->
        <javaMdxConfiguration active="true"/>

        <!--
            (Optional) Access to JAVA native functions from MDX statement.
        -->
        <javaMdxNativeConfiguration active="true"/>

        <!--
            (Optional) Access to JAVA from schema/cube builder.
        -->
        <javaViewConfiguration active="true"/>

    </olapEngineComponentConfiguration>

    <!--
        icCube Server Properties.
    -->
    <icCubeProperties>

        <!--
            Disable the load on startup schema processing (handy when having a lot of schema
            definition files and load on startup property is never used).
        -->
        <disableLoadOnStartupSchema value="false"/>

        <!--
            Add a bit of information in the log file about garbage collection activity.
        -->
        <gcInfoActive value="true"/>

        <!--
            Log each N milliseconds GC information if available.
        -->
        <gcInfoMillis value="200"/>

        <!--
            An optional absolute directory that is defining the root of the file system
            visible by icCube when browsing/accessing the file system. Every file defined
            within icCube is going to be relative within this root (e.g., builder data
            source data).

            An empty string is making the entire file system visible (not recommended
            in production for security reason).

            Multi-Tenant : icCube will assume this directory contains a sub-directory
            named $tenants$ that in turn contains for each tenant a directory named
            using the tenant directory name.

            e.g., /icCubeData/$tenants$
                     /France               tenant: France
                     /Spain                tenant: Spain

        -->
        <fileSystemRoot value=""/>

        <!--
            The file system content is visible from within the Docs application.

            Administrator and Docs. Administrator only.
        -->
        <fileSystemRootVisibleInDocs value="false"/>

        <!--
            An optional directory containing icCube plugins.
        -->
        <additionalPlugins value=""/>

        <!--
            Allows for displaying (or not) the icCube icon in the system tray.
            Note that the system tray is not available on all the supported platforms.
        -->
        <systemTrayIcon value="true"/>

        <!--
            Maximum size (byte) of schema definition XML files for GUI deployment.
            This is the size after the file has been zipped.
        -->
        <maxSchemaDefinitionFileSizeForDeploymentZipped value="1048576"/>

        <!--
            Maximum size (byte) of file when shown in the GUI (e.g., show schema definition XML file).
        -->
        <maxFileSizeForGuiVisualization value="11534336"/>

        <!--
            UI : maximum number of child nodes in MDX debugger tree.
        -->
        <maxChildrenCountForMdxDebugger value="100"/>

        <!--
            UI : maximum number of child nodes in schema browser tree.
        -->
        <maxChildrenCountForSchemaBrowser value="100"/>

        <!--
            UI: maximum number of members retrieved initially by the dimension browser (builder).
        -->
        <maxMemberCountForBrowseDimension value="100000"/>

        <!--
            UI : default page size when browsing data table (schema data source).
        -->
        <maxRowCountForBrowseDataTable value="100"/>

        <!--
            Memory mapped files: allows for switching off explicit unmap usage.
        -->
        <unmapOff value="false"/>

        <!--
            Vector Parallel Sort: allows for switching off explicit parallel sort usage.
        -->
        <vectorParallelSortOff value="false"/>

        <!--
            Switch off the ability to access measures from different cubes in a select statement.

                Upgrading from version v7.10, set to true to keep existing backups.
                From v7.11 onwards, changing the flag is breaking the backups.
        -->
        <singleMeasureDimensionalityOff value="false"/>

        <!--
            UI: the default page size for table with pagination (e.g., requests, schemas, etc...)
        -->
        <ux.pagination.pageSize value="10"/>

        <!--
            UI: the default page sizes for table with pagination (e.g., requests, schemas, etc...)
        -->
        <ux.pagination.pageSizes value="5, 10, 20, 30, 40, 50"/>

        <!--
            Reporting : number of seconds after which a long polling request is completed
            whatever the actual status of the requested schema updates (defaults: 600s).
        -->
        <report.refreshOnDataUpdate.waitTimeout value="600"/>

    </icCubeProperties>

    <!--
        Authentication service that is used by the authentication servlet filters.

        A Java system property can be used as param.value.
    -->
    <icCubeAuthenticationService>

        <service-class>crazydev.iccube.server.authentication.IcCubeAuthenticationService</service-class>

        <!--
            Optional parameter to specify whether the names of the users are case-sensitive ( value: true | false ).
            Default value is : false.
        -->
        <!--
                <param>
                    <name>caseInsensitive</name>
                    <value>true</value>
                </param>
        -->

        <!--
            The minimum length for a password (UX only), this will apply to new passwords defined in the UX console.
        -->
        <param>
            <name>pwdMinLength</name>
            <value>5</value>
        </param>

        <!--
            Password Hash algo ( http://en.wikipedia.org/wiki/PBKDF2 ) : number of iterations.
            You can check icCube's logs for 'Password' to check how long it's going to take in your server.

            NOTE : changing the parameters below will INVALIDATE your current passwords. Change with care.
        -->
        <param>
            <name>pwdIterations</name>
            <value>10000</value>
        </param>

        <!--
            Password Hash algo : length of the salt (bytes).
        -->
        <param>
            <name>pwdSaltLength</name>
            <value>32</value>
        </param>

        <!--
            Password Hash algo : length of the key (bits)  (it's advisable to put 8 * pwdSaltLength).
        -->
        <param>
            <name>pwdKeyLength</name>
            <value>256</value>
        </param>

        <!--
            (Optional)

            Allow to retrieve the username from an HTTP header instead of the standard form. In that mode,
            no password is being required. The authentication is being performed outside icCube.
        -->
        <!--
                <param>
                    <name>userNameFromHeader</name>
                    <value>IC3_USER_NAME</value>
                </param>
        -->

        <!--
            (Optional)

            If the user definition does not exist, then a user with this role is being created.
            The definition of this user is not persisted. The role definition must exist.
            If this header does not exist, then the missingUserRole is used (see below).
        -->
        <!--
                <param>
                    <name>userRoleFromHeader</name>
                    <value>IC3_ROLE_NAME</value>
                </param>
        -->

        <!--
            (Optional)

            If the user definition does not exist, then a user with this role is being created.
            The definition of this user is not persisted. The role definition must exist.
        -->
        <!--
                <param>
                    <name>missingUserRole</name>
                    <value>standard</value>
                </param>
        -->

        <!--
            (Optional)

            The locale used when creating the missing user (see missingUserRole).
        -->
        <!--
                <param>
                    <name>missingUserLocale</name>
                    <value>en</value>
                </param>
        -->

        <!--
            (Optional)

            The URL to use when reloading the browser page after a logout.
        -->
        <!--
                <param>
                    <name>logoutRedirectUrl</name>
                    <value>https://your.api.com/logout</value>
                </param>
        -->

        <!--
            (Optional)

            When activated, on-the-fly permissions are evicted from the permissions service
            depending on the policy defined.

            Default: false
        -->
        <param>
            <name>onTheFlyPerms.eviction</name>
            <value>true</value>
        </param>

        <!--
            (Optional)

            When eviction is activated, a housekeeping job is running every 'evictionHousekeepingPeriod' minutes
            to check for idle permissions to delete.

            Default: 10
        -->
        <param>
            <name>onTheFlyPerms.evictionHousekeepingPeriod</name>
            <value>10</value>
        </param>

        <!--
            (Optional)

            On-the-fly permissions not used after 'evictionIdlePeriod' minutes are deleted.

            Default: 30 minutes
        -->
        <param>
            <name>onTheFlyPerms.evictionIdlePeriod</name>
            <value>30</value>
        </param>

    </icCubeAuthenticationService>

    <!--
        Optional monitoring counters.
    -->
    <monitoringConfigurations>

        <!--
            Several <counters> elements might be defined...
        -->
        <counters>

            <!--
                Whether these monitoring counters are activated ( true | false )
            -->
            <activated>false</activated>

            <!--
                A comma separated string containing the list of counters to monitor; use '*' for all available.
                See https://doc.iccube.com/?ic3topic=server.mdx.icCubeCounters
            -->
            <counterFilter>*</counterFilter>

            <!--
                A comma separated string containing the list of feature to audit; use '*' for all available.

                  report : allows for monitoring opened reports

                  mdx    : allows for monitoring elapsed time of MDX requests (default threshold is 10 sec )
                           use mdx:N to specify a threshold of N seconds (mdx:-1 is auditing cached requests
                           as well).

                The audited information is available in the directory icCube-data/audit and via the $Audit
                schema if deployed.
            -->
            <auditFilter>*</auditFilter>

            <!--
                Reporters are handling the monitoring output (e.g. cube, logs, etc...).

                - crazydev.iccube.server.bigbrother.reporter.IcBigBrotherOlapCubeReporter  : [$Monitoring] schema
                - crazydev.iccube.server.bigbrother.reporter.IcBigBrotherReporter4J        : LOG4J

            -->
            <reporters>

                <reporter>
                    <className>crazydev.iccube.server.bigbrother.reporter.IcBigBrotherOlapCubeReporter</className>

                    <!--
                        Optional boolean parameter : control the permissions applied to the $Monitoring schema.

                        When false, the Application Permissions, Monitoring / Counters is being used to determine
                        if the $Monitoring schema is being accessible otherwise regular schema permissions are
                        applied.

                        Default : false.
                    -->
                    <param>
                        <name>useSchemasPerms</name>
                        <value>false</value>
                    </param>

                    <!--
                        Optional parameter : name of the generated schema (default : $Monitoring)
                    -->
                    <param>
                        <name>schemaName</name>
                        <value>$Monitoring</value>
                    </param>

                    <!--
                        Optional parameter : name of the cube within the generated schema (default : $Monitoring)
                    -->
                    <param>
                        <name>cubeName</name>
                        <value>$Monitoring</value>
                    </param>

                    <!--
                        Optional parameter : max. size of audit files (use suffix: KB, MB or GB).
                    -->
                    <param>
                        <name>maxFileSize</name>
                        <value>2MB</value>
                    </param>

                    <!--
                        Optional parameter : max. number of rolling files for audit data.
                    -->
                    <param>
                        <name>maxBackupIndex</name>
                        <value>9</value>
                    </param>

                </reporter>

                <reporter active="false">
                    <!--
                        Similar to previous $Audit$ reporter with the following differences:

                        - There is no limit in the number of file generated. The last .csv.N file is
                        the most recent and the only actually used by icCube.

                        - MDX threshold does not apply (all MDX are audited).
                    -->
                    <className>crazydev.iccube.server.bigbrother.legal.IcBigBrotherLegalAuditReporter</className>

                    <!--
                        Optional parameter : max. size of audit files (use suffix: KB, MB or GB).
                    -->
                    <param>
                        <name>maxFileSize</name>
                        <value>2MB</value>
                    </param>

                    <!--
                        Optional parameter : name of the file for the audited opened reports.
                        Default is : legal_opened_report.csv
                    -->
                    <param>
                        <name>openReportFileName</name>
                        <value>legal_opened_report.csv</value>
                    </param>

                    <!--
                        Optional parameter : name of the file for the executed MDX queries.
                        Default is : legal_mdx.csv
                    -->
                    <param>
                        <name>mdxFileName</name>
                        <value>legal_mdx.csv</value>
                    </param>

                </reporter>

            </reporters>

            <!--
                The initial delay in seconds before the monitoring of the counters is actually started.
            -->
            <initialMonitorBeansDelaySec>5</initialMonitorBeansDelaySec>

            <!--
                Frequency in seconds at which each counter/audit value is collected.
            -->
            <monitorBeansEachSec>3</monitorBeansEachSec>

            <!--
                Frequency in seconds at which the system records the counter/audit statistics.
            -->
            <reportingWindowSec>60</reportingWindowSec>

        </counters>

    </monitoringConfigurations>

    <!--
        (optional) Multi-tenant support.

        https://doc.iccube.com/?ic3topic=server.user_guide.multitenant.multitenant

        Please contact us for more details.
    -->
    <multiTenantConfiguration active="false">

    </multiTenantConfiguration>

    <!--
        Additional MIME types (optional textual allows for editing file into the Docs application).
    -->
    <mimeTypes>
        <!--
                <mimeType>
                    <ext>icc-schema</ext>
                    <mime>application/xml</mime>
                    <textual>true</textual>
                </mimeType>
        -->
    </mimeTypes>

    <!--
        (Optional) User defined properties that can be accessed from plugins.
    -->
    <userDefinedProperties>

        <!--
           Allowing using a web token authorization for Google data sources (e.g. Drive, Analytics..)

           Google OAuth 2.0 client https://console.cloud.google.com/apis/credentials

            Value :
               - For production,  the value should be a valid path to a certification file (secret) for YOUR solution
               - To disable the feature, empty value
               - For testing, the icCube certification file -> 'icCube'
        -->
        <property>
            <name>google.oauth2.secretFile</name>
            <value>icCube</value>
        </property>

    </userDefinedProperties>

    <!--
        (Optional)

        When started with the cluster configuration being active, several icCube servers can share
        the icCube-data directory.
    -->
    <clusterConfiguration active="false">

    </clusterConfiguration>

</icCubeConfiguration>
```

### HTTP Web Servers

The following links are providing information about configuring icCube behind a Web server:

* [Apache Web Server](apache_web_server.md)
* [NGINX](nginx_web_server.md)

Next chapter : [Notifications](iccube_notification_xml.md) configuration.

_
