## MDX Post Processing

An MDX query can contain post processors that will be executed **after** the MDX query has run. 

* [Dimension Properties](./DimensionProperties.md)
* [Multiple Linear Regression](./MultipleLinearRegression.md)

### Syntax

Regular MDX statements can be followed by or more `TidyPostProcessor` statements. Each statement is processing the
result of the previous post processor to generate a new result (note that the first post processor is processing the
result of the initial MDX request). The result of each post processor can be added to the result of the request. Note 
that the result of the last post processor is the actual result of the MDX request.  

For example, the following is performing a multiple linear regression of several observations : 

```
SELECT
   {[Measures].[Y], [Measures].[X1], [Measures].[X2], [Measures].[X3]} on 0
   [Observation].[Observation].[Observation] on 1
FROM [Cube]
   
TIDYPOSTPROCESSOR  MultiLinearRegression()
```

### Result

The result of a regular MDX request is sent to the reporting application as a tidy table.

The format of the tidy table has been extended to contain the result of the `TidyPostProcessor` steps. The result
of the last `TidyPostProcessor` is the actual tidy table used as the result of the whole MDX request. The previous
post processor(s) and/or initial MDX request results can be added to this tidy table as `steps`.

For example, the following request is adding the initial MDX request as the first step :

```
SELECT
   {[Measures].[Y], [Measures].[X1], [Measures].[X2], [Measures].[X3]} on 0
   [Observation].[Observation].[Observation] on 1
FROM [Cube]
   
TIDYPOSTPROCESSOR ADD_TO_RESULT MdxResult()
TIDYPOSTPROCESSOR MultiLinearRegression()
```

`MdxResult()` is a special post processor giving access to the initial MDX request result.

### See Also

[REST API TidyExecuteMdxScript](../api/TidyExecuteMdxScript.md)

_