## MDX Object-Oriented (OO) Extensions (MDX++)

When evaluating a tuple, MDX will return a value that is the result of aggregating over the sub-cube cell values
or evaluating an MDX expression. For example, the tuple `([2010],[Sales Amount])` will return all sales for `2010`
aggregating values over all cells belonging to the sub-cube of `[2010]`.

In MDX the value of a tuple is not constrained to a floating point value, it can be of different types :
floating point, date, datetime, string, vector of floating points,matrix of floating points or an empty value.
It's important to note for people coming from development languages that there is no actual integer and that
`1 / 2` will return `0.5` even though values are defined as integers. Some types - strings, dates and times -
cannot be aggregated and will return an error if the tuple contains more than one cell with a value. The empty
value represents a special type that defines no value or empty result.

The types support different operations as sum, division, comparison. For example `2 + 1 / 2` will return `2.5`.
This is known as operator overloading in development.

Additionally, in icCube the MDX language has been extended so that results of tuple evaluations are not limited
anymore to simple MDX types (e.g., numerical, string). In theory any object can be returned and then manipulated
using its own methods. As an example, icCube [vectors](vector.md) are quite handy for performing mathematical
and/or statistical operations. Those types are good candidates for caching as explained in the
[documentation](../mdx/cellProperties/REQUEST_CACHED.md).

### Object Methods

The notation `object->method( ... )` allows for accessing the methods of the objects. Note that the conversion
of the parameters (as well as the result) is handled automatically by the MDX engine. As an example, the following
code return the arithmetic mean of the amount of sales for all the countries:

    Vector( [Geography].[Geo].[Country].members, [Measures].[Amount] )->mean()

### Types

The following is a list of supported types in icCube :

* Floating Point
* String
* Empty
* [Date & Datetime](dateandtime.md)
* [Vector](vector.md)
* [Matrix](matrix.md)

_
