## Members, Tuples, and Sets

Members represent the concrete data of this meta-definition (e.g. `Switzerland` as a country). Each level of a given
hierarchy will 'produce' a member with a parent-child relationship.

The object representing the upper level of `Switzerland` (continent) is also a member in MDX:

* `[Geography].[Geo].[Europe]`: is a continent with all European countries as children
* `[Geography].[Geo].[Europe].[Switzerland]`: is a country whose parent member is Europe
* `[Geography].[Geo].[Europe].[Switzerland].[Geneva]`: is a city (whose parent member is Switzerland

Representing the full hierarchy on rows as a tree, would appear as follows:

    Select
        [Measures].[Amount] on 0,
        [Geography].[Geo].members on 1
    From
        [Sales]

The amount column is aggregating the measure for each member of the dimension (more on this later):

                        Amount

    Europe               255.0
      Spain                3.0
      Madrid               1.0
      Barcelona            2.0
      Valencia           
    Switzerland          248.0
      Lausanne            56.0
      Geneva             128.0
      Zurich              64.0
    France                 4.0
      Paris                4.0
    America              768.0
      United States      768.0
      New York           768.0
      San Fransisco 
      Los Angeles
    Canada      
      Quebec      
      Toronto     
    Mexico      
      Mexico      
    Venezuela     
      Caracas     

A tuple is the intersection of one (and only one) member taken from each of the dimensions in the cube.
A tuple identifies a single cell in the multi-dimensional matrix.

The easiest way to understand a tuple is to look at an Excel sheet. In the Excel sheet a cell is identified by
A1, A2, A3, B1, B2, B3, etc. Here A represents a coordinate from the columns and 1 represents a coordinate
from the rows. We put these together and we can uniquely identify a cell in the sheet. Here A1, B1 are examples
of tuples. In a cube there are many dimensions and a tuple is defined as a list of a single hierarchy member taken
from all the dimensions (e.g., `[New York]`, `[2009]`). The net effect is the same. The tuple always points
to a single cell in the cube.

When defining our business case, we defined several dimensions and one measure. Those dimensions can be seen as
discrete coordinates of a cube. Just as 'x,y,z' represent the coordinates of points in space, members of our dimensions
represent the coordinates in our cube. The measure being the value of this cube.

For example, `Patty Bing sold one corporate license 2009 Q4 in Los Angeles` is represented by the tuple:

    ([People].[Patty Bing], [Prod].[License].[Corporate], [Time].[Calendar].[Q4 2009], [Geography].[Geo].[Los Angeles], [Measures].[Amount])

A tuple dimensionality is defined as the ordered list of the members hierarchies. For example, the previous tuple
dimensionality is:

    ([People].[People], [Product].[Prod], [Time].[Calendar], [Geography].[Geo], [Measures])

Within a hierarchy, intermediate members (a.k.a. parent members) do not represent actual coordinates of measures in
our cube. Therefore, the MDX aggregation and calculation engine is going to compute those measures by **aggregating**
the measures values of their children (and grandchildren).

This means that `([Patty Bing], [2009])` is going to return the `amount of licenses` sold by `Patty Bing` during
the whole year `2009` (aggregating the amount for each quarter of 2009).

Sets are an ordered collection of 0 or more tuples (note that a member is considered to be a tuple containing a
single element) with the same dimensionality. Unlike a mathematical set, an MDX set may contain duplicates, it is
more of a list of elements. So, the same member/tuple can be in a list twice. Sets are defined using curly brackets:

    {[Geography].[Geo].[Europe].[Switzerland], [Geography].[Geo].[Europe].[France]}

Members of a set must be from the same hierarchy. For example, the following set is invalid:

    {[Geography].[Geo].[Europe].[Switzerland], [Product].[License].[Corporate]}

The following set is invalid because of different tuple dimensionalities:

    {
      ( [Time].[Calendar].[2010], [Geography].[Geo].[Europe].[Switzerland] ),
      ( [Time].[Calendar].[2010], [Product].[License].[Corporate] ) 
    }

## Next Step

Let's take a little break and look at the different ways we have of selecting members in MDX :
[member name](member_name.md).

_