## Overview

MDX is the multidimensional query language used by icCube to query its cube-like data models
(see our [MDX tutorial](../mdx_tutorial/gentle_introduction.md) for more information). A typical
MDX query looks like the following:

```
select 
   [Measures].members on 0
   [Geography].[Geography].[Country] on 1
from [Sales] 
```

### Pivot vs. Tidy Table

Once executed the result of an MDX query is converted to a [tidy table](../../dashboards/tidyTable/TidyTable.md).
The columns of the tidy table are made of the hierarchies/levels of the axes greater than 0 and the tuples of 
the axis 0. There is no limit in the number of axes in the query. When rendering the result using a pivot table, 
the MDX query is limited to two axes only unless the last one is called `"#Measures"`. In that case, each cell 
contains a _vector_ of the tuples specified in that last axis.

### Code Editor Shortcuts

- `CTRL+SPACE` : code and MDX entities completion,
- `Click` : when hovering over functions, opens the help in the right window.
- `CTRL/⌘+Click` : when hovering over functions, opens the help in a new tab.

### Role Impersonation

When logged as an administrator, the `User` [annotation](../mdx/Annotations.md) allows for executing the request
with the defined role. The following is processing the query using the `reader` role :

```
//#User( role = 'reader' )
select from [Sales]
```

### See Also

* [Tutorial (Gentle Introduction)](../mdx_tutorial/gentle_introduction.md)
* [Object-Oriented (OO) Extensions (MDX++)](../mdx_types/types_and_oo_extension.md)
* [Integration](../mdx_integration/index.md)
* [Functions Reference](../mdx/functions.md)
* [Language Reference](../mdx/language.md)
* [Post Processing](../post_processing/index.md)
* [Debugging](../user_guide/using/debugging.md)
* [Commands](../user_guide/using/exec_commands.md)
* [FAQ](../mdx_faq/mdx_faq.md)

_