## icCube MDX Errors

Here is the list of icCube MDX errors along with their description.


### OLAP_NOT_AUTHORIZED

Description : Raised when the evaluation of a MDX statement is not authorized.
Code        : 0x56c75d6e


### OLAP_MDX_STATEMENT_TYPE_MISMATCH

Description : Raised when evaluating a MDX query that is not a statement.
Code        : 0x194577cb


### OLAP_MDX_SCRIPT_TYPE_MISMATCH

Description : Raised when evaluating a MDX query that is not a script.
Code        : 0x37eb5a5e


### OLAP_MDX_SCRIPT_WITH_SELECT

Description : Raised when evaluating a multi-statement MDX script containing one or more SELECT statements.
Code        : 0xb7867d6c


### OLAP_EVAL_CANCELLED

Description : Raised when the processing has been cancelled.
Code        : 0xb283d65b


### OLAP_SELECT_EVAL_UNEXPECTED_ERROR

Description : Raised when an internal error occurred during the processing of a SELECT statement.
Code        : 0x3d5b603c


### OLAP_SELECT_EVAL_AXES_ERROR

Description : Raised when the evaluation of SELECT ... ON AXES has not generated a single cell (MatrixA or VectorA) result.
Code        : 0x7de809ca


### OLAP_SELECT_MAX_CELL_COUNT

Description : Raised when the maximum of number of cells as specified by the icCube.xml property icCube.selectCellMaxCount has been reached.
Code        : 0x65505228


### OLAP_UNARY_OPERATOR_SYNTAX_ERROR

Description : Raised while attempting to use an operator with a non supported type (e.g., -TRUE).
Code        : 0x80375600


### OLAP_BINARY_OPERATOR_SYNTAX_ERROR

Description : Raised while attempting to use an operator with a non supported type (e.g., 42 AND "hello").
Code        : 0xa9fc7816


### OLAP_RANGE_OPERATOR_MEMBER_LEVEL_MISMATCH

Description : Raised when creating a range between members of different levels.
Code        : 0x37823bb2


### OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH

Description : Raised when passing an argument of non expected type to the function.
Code        : 0xba1de074


### OLAP_FUNCTION_ARGUMENT_ERROR

Description : Raised when passing an argument has an error
Code        : 0x25910bd0


### OLAP_FUNCTION_ARGUMENT_MISSING

Description : Raised when an expected function argument is missing.
Code        : 0xbc53ac78


### OLAP_FUNCTION_ARGUMENT_NULL

Description : Raised when an expected non-null function argument is null or has been evaluated to null.
Code        : 0x6eb5ff27


### OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT

Description : Raised when using more (or less) arguments then the function is expecting.
Code        : 0x2c2abe1


### OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT_X

Description : Raised when using more (or less) arguments then the function is expecting.
Code        : 0x1f2b30ad


### OLAP_FUNCTION_EXPECT_MEMBERS_AT_SAME_LEVEL

Description : Raised when a set of member of different levels is passed as parameter.
Code        : 0x4b4c3b78


### OLAP_FUNCTION_DIMENSION_WITH_NO_HIERARCHY

Description : It is more likely that current permissions have disabled access to all the hierarchies.
Code        : 0x8dcd3879


### OLAP_FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY

Description : MDX names must contain the hierarchy name when the dimension is containing more than one hierarchy.
Code        : 0xe99f9503


### OLAP_TO_SET_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY

Description : MDX names must contain the hierarchy name when the dimension is containing more than one hierarchy.
Code        : 0xfb6392af


### OLAP_CONST_FUNCTION_AS_NAMED_SET_USAGE

Description : Raised when a const function is accessing a named set (i.e., AS notation).
Code        : 0x69a46a44


### OLAP_USER_JAVA_FUNCTION_EVALUATION_GENERAL

Description : Raised by a user defined function (i.e., plugin).
Code        : 0x3155d3c5


### OLAP_CUBE_UNKNOWN

Description : Raised when attempting to use an unknown cube.
Code        : 0x62d1e998


### OLAP_CUBE_UNKNOWN_SET

Description : Raised when attempting to use an unknown cube specified in a create set statement.
Code        : 0xd880a8e2


### OLAP_CUBE_UNKNOWN_FUNCTION

Description : Raised when attempting to use an unknown cube specified in a create function statement.
Code        : 0x8707b7dd


### OLAP_CUBE_DYNAMIC_SET_MISMATCH

Description : Raised when a dynamic set is defined using a cube that is not the request cube.
Code        : 0x95237698


### OLAP_DUPLICATED_ACTION

Description : Raised when declaring more than one action with the same name.
Code        : 0x586d3c76


### OLAP_DRILLTHROUGH_ACTION_TARGET_NAME_ERROR

Description : Raised when the name of the target (measure group) is invalid.
Code        : 0x2f4fcc16


### OLAP_DRILLTHROUGH_ACTION_TARGET_NAME_MISSING_CUBE

Description : Raised when the name of the target (measure group) is missing the cube name.
Code        : 0x4983f518


### OLAP_DRILLTHROUGH_ACTION_TARGET_NAME_NO_CUBE

Description : Raised when an action is defined for a schema without any cube.
Code        : 0x12cb657


### OLAP_DUPLICATED_NAMED_SET

Description : Raised when declaring more than one named set with the same name.
Code        : 0xe752c7d7


### OLAP_DUPLICATED_FUNCTION

Description : Raised when declaring more than one function with the same name.
Code        : 0x95378892


### OLAP_DUPLICATED_CALC_MEMBER

Description : Raised when declaring more than one calculated member with the same name.
Code        : 0x8133d496


### OLAP_DUPLICATED_MEASURE

Description : Raised when declaring more than one measure with the same name.
Code        : 0x1c11be3c


### OLAP_CALC_MEASURE_UNKNOWN_ASSOCIATED_MEASURE_GROUP

Description : Raised when a calculated measure attempt to reference an unknown ASSOCIATED_MEASURE_GROUP '%s'.
Code        : 0x8f6a6179


### OLAP_CALC_MEMBER_ASSOCIATED_MEASURE_GROUP

Description : Raised when a calculated member attempt to define an ASSOCIATED_MEASURE_GROUP property.
Code        : 0xd5b4cff7


### OLAP_CALC_MEMBER_DISPLAY_FOLDER

Description : Raised when a calculated member attempt to define an DISPLAY_FOLDER property.
Code        : 0x8b268af6


### OLAP_CALC_MEMBER_STACK_OVERFLOW

Description : Raised when the evaluation of a calculated member/measure recurses too deeply (see icCube.calcMemberMaxEvaluationFrameStackSize XMLA property).
Code        : 0xf01878f6


### OLAP_FUNCTION_STACK_OVERFLOW

Description : Raised when the evaluation of a declared function (i.e., WITH FUNCTION) recurses too deeply (see icCube.functionMaxEvaluationFrameStackSize XMLA property).
Code        : 0xd37fee9


### OLAP_SCALAR_ENTITY_TYPE_MISMATCH

Description : Raised when an entity cannot be converted to a scalar value.
Code        : 0x93811e1b


### OLAP_CALC_MEMBER_TYPE_MISMATCH

Description : Raised when the evaluation of a calculated member has generated a value non expected by the [Measures] dimension (i.e., scalar value).
Code        : 0x1116627b


### OLAP_CALC_MEMBER_MISSING_ENTITY

Description : Raised when attempting to register a calculated member (or measure) into an unknown entity (e.g., member, level, ...).
Code        : 0xeb9799e


### OLAP_CALC_MEMBER_ORPHAN

Description : Raised when attempting to register a calculated member into a level (depth > 0) without specifying any parent.
Code        : 0xd68ec095


### OLAP_CALC_MEMBER_LAST_LEVEL

Description : Raised when attempting to register a calculated member (or measure) into a member of the last level.
Code        : 0xd5cdd27d


### OLAP_CALC_MEMBER_ANCHOR_TYPE

Description : Raised when attempting to register a calculated member (or measure) into an entity of unexpected type.
Code        : 0x6a8e559a


### OLAP_CALC_MEMBER_NON_EMPTY_BEHAVIOR_UNKNOWN_MEASURE_GROUP

Description : Raised when the NON_EMPTY_BEHAVIOR property of a calculated measure is referencing an unknown measure group.
Code        : 0xb5f3020a


### OLAP_CELL_FORMATTER_CREATION_ERROR

Description : Raised when the creation of a FORMAT_STRING formatter has generated an error.
Code        : 0xdf335e48


### OLAP_SLICER_AGGREGATION_MEASURES

Description : Raised when the slicer contains more than one Measures member as aggregating the values would make no sense.
Code        : 0xf35f5e3d


### OLAP_SLICER_AGGREGATION_CALC_MEMBERS

Description : Raised when the slicer is defined as a set and contains calculated members.
Code        : 0xbe434eb3


### OLAP_SLICER_SET_CURRENT_MEMBER

Description : Raised when attempting to get the current member from the slicer when the slicer contains a set.
Code        : 0xa7066db1


### OLAP_SLICER_NULL_EVAL

Description : Raised when the slicer has been evaluated to a NULL member or an empty set.
Code        : 0xc4421623


### OLAP_SLICER_AXIS_MULTIPLE_HIERARCHY

Description : Raised when a hierarchy is used both in the slicer and in one axis.
Code        : 0x8e131618


### OLAP_MDX_ERROR_FUNCTION

Description : Raised by the MDX function .Error() function.
Code        : 0xcbacc669


### OLAP_MATRIX_ERROR

Description : Raised by the Matrix function.
Code        : 0x434c79f9


### OLAP_VECTOR_ERROR

Description : Raised by the Vector function.
Code        : 0x5a68f65b


### OLAP_AXIS_SELECT_SEQUENCE_ERROR

Description : Raised when an invalid axis sequence is used (i.e., not 0, 1, ... or COLUMNS, ROWS, ...)
Code        : 0xc9d39912


### OLAP_AXES_USAGE_ERROR

Description : Raised when Axes is used with one or more other axis.
Code        : 0x55e7a4c0


### OLAP_AXIS_SELECT_MULTIPLE_HIERARCHY

Description : Raised when the same hierarchy is selected in more than one axis.
Code        : 0xd2d2b7da


### OLAP_MDX_SESSION_MISMATCH

Description : Raised when a session entity is being created in a session-less environment.
Code        : 0x9b445a37


### OLAP_MDX_DEBUG_SESSION_MISMATCH

Description : Raised when debugging a MDX query in a session-less environment.
Code        : 0xb5a760d7


### OLAP_MDX_AXIS_FUNCTION_MISSING_AXIS

Description : Raised when referencing (using the Axis() function) an axis not evaluated yet.
Code        : 0x667c6f57


### OLAP_CONSTRAINED_VIOLATED

Description : Raised when evaluating a MDX function using the CONSTRAINED flag has failed.
Code        : 0xce5eef


### OLAP_CELL_PROPERTY_UNKNOWN

Description : Raised when referencing a non-existing CELL property.
Code        : 0x157cc216


### OLAP_CELL_PROPERTY_UNKNOWN_X

Description : Raised when referencing a non-existing CELL property.
Code        : 0x70b88995


### OLAP_CELL_PROPERTY_READ_ONLY

Description : Raised when attempting to set a value to a read-only property (e.g., ORDINAL = 42).
Code        : 0xaffd1dd4


### OLAP_TIDY_POST_PROCESSOR_UNKNOWN

Description : Raised when referencing a non-existing tidy post processor.
Code        : 0x642c77d5


### OLAP_TIDY_POST_PROCESSOR_NO_CELL_ON_ERROR

Description : Raised when a tidy post processor receives a result with a cell on error.
Code        : 0x34593d8


### OLAP_TIDY_POST_PROCESSOR_NO_MAX_ROW_COUNT_REACHED

Description : Raised when a tidy post processor receives a truncated result.
Code        : 0x7b20966f


### OLAP_TIDY_POST_PROCESSOR_NO_PAGING

Description : Raised when a tidy post processor receives a result with paging information.
Code        : 0x57a1edd1


### OLAP_TIDY_POST_PROCESSOR_UNEXPECTED_ARGS_COUNT

Description : Raised when the wrong number of arguments is passed to the post processor.
Code        : 0x20c13a96


### OLAP_TIDY_POST_PROCESSOR_ERROR

Description : Raised when a non-expected error is raised in the tidy post processor.
Code        : 0x1bfcf014


### OLAP_CAT_EVAL_ERROR

Description : Raised when a category cannot be evaluated
Code        : 0xbd8f3392


### OLAP_CAT_HIERARCHY_DELETE_SCOPE_MISMATCH

Description : Raised when attempting to DROP a CATEGORY HIERARCHTY with the wrong scope (i.e., SCHEMA, SESSION)
Code        : 0xea2a7a70


### OLAP_CAT_HIERARCHY_DUPLICATED

Description : Raised when attempting to create a CATEGORY HIERARCHTY with the same name.
Code        : 0xffad9952


### OLAP_CAT_HIERARCHY_PROPERTY_UNKNOWN

Description : Raised when referencing a non-existing CATEGORY HIERARCHTY property.
Code        : 0x920d53e8


### OLAP_CAT_MEMBER_PROPERTY_UNKNOWN

Description : Raised when referencing a non-existing CATEGORY MEMBER property.
Code        : 0x859c308


### OLAP_CAT_MEMBER_TUPLES_INVALID

Description : Raised when the expression of a category member does not generate a set of tuples or a sub-cube .
Code        : 0x6cfa463a


### OLAP_CAT_MEMBER_WITH_CALC_MEMBER

Description : Raised when a category member reference either a measure or a calculated member.
Code        : 0xc667843a


### OLAP_CAT_MEMBER_ANCHOR_MISSING

Description : Raised when a category member is defining a non existing parent.
Code        : 0x1d1ac41f


### OLAP_CAT_MEMBER_ANCHOR_INVALID_CALC_MEMBER

Description : Raised when the parent of category member is a calculated member.
Code        : 0x40f3176


### OLAP_CAT_MEMBER_ANCHOR_INVALID_HIERARCHY

Description : Raised when a category member is defined within a hierarchy does not accept category members.
Code        : 0xe1276afd


### OLAP_CAT_MEMBER_ANCHOR_INVALID_TYPE

Description : Raised when a category member is not a member.
Code        : 0x57dd3435


### OLAP_CAT_MEMBER_OVERWRITE_MEMBER

Description : Raised when a category is overwrite an existing member.
Code        : 0x9d88a030


### OLAP_CAT_MEMBER_DROP_INVALID_TYPE

Description : Raised when attempting to delete a non category member.
Code        : 0xc7fe38dc


### OLAP_CAT_HIERARCHY_DIMENSION_MISMATCH

Description : Raised when a category hierarchy is referencing a dimension that cannot contain category.
Code        : 0x52993452


### OLAP_CAT_HIERARCHY_DIMENSION_UNKNOWN

Description : Raised when a category hierarchy is referencing an unknown dimension
Code        : 0xaaaf8715


### OLAP_CAT_HIERARCHY_NAME_INVALID

Description : Raised when the name of the category hierarchy is invalid
Code        : 0x8e252b32


### OLAP_CAT_HIERARCHY_MISMATCH

Description : Raised when a category member is referencing a schema hierarchy in the wrong scope.
Code        : 0xf9f9851


### OLAP_CAT_CALC_WITH_CHILDREN

Description : Raised when a calculated category member is using the ADD_CHILDREN property.
Code        : 0xa2b1ff64


### OLAP_CAT_CALC_SESSION

Description : Raised when a calculated category member is defined at session level.
Code        : 0x344d3fbb


### OLAP_CAT_CREATE_CHILD_IN_ADD_CHILDREN

Description : Raised when adding a child to a category member defined with ADD_CHILDREN.
Code        : 0xcfa7acc2


### OLAP_MEMBER_PROPERTY_UNKNOWN

Description : Raised when referencing a non-existing MEMBER property.
Code        : 0xd8120c93


### OLAP_MEMBER_PROPERTY_UNKNOWN_X

Description : Raised when referencing a non-existing MEMBER property.
Code        : 0x4a90c742


### OLAP_MEMBER_PROPERTY_CONTEXT_SENSITIVE

Description : Description not available yet.
Code        : 0x6c0e12b1


### OLAP_MEMBER_PROPERTY_UNKNOWN_CONTEXT

Description : Description not available yet.
Code        : 0x3864d477


### OLAP_MEMBER_PROPERTY_CONTEXT_TYPE_MISMATCH

Description : Description not available yet.
Code        : 0xd4239e9e


### OLAP_PROPERTY_NOT_FOUND

Description : Raised when requesting a non-existing property using the .Properties() function.
Code        : 0xdc141477


### OLAP_FUNCTION_AS_PARAMETER_DUPLICATED

Description : Raised when using duplicated names within the function declaration of the arguments AS named sets.
Code        : 0xc998f690


### OLAP_UNKNOWN_MEASURE

Description : Raised when referencing a [Measures] that does not exist within the cube.
Code        : 0xa022e12b


### OLAP_UNKNOWN_DIMENSION_HIERARCHY

Description : Raised when referencing a dimension and/or hierarchy that does not exist within the cube.
Code        : 0xf291cb7d


### OLAP_UNKNOWN_ENTITY

Description : Raised when referencing an entity that does not exist within the cube (see icCube.mdxEvalUnknownMemberError XMLA property).
Code        : 0x4455f93d


### OLAP_DYNAMIC_CATEGORY_USAGE

Description : Raised when using a DYNAMIC category '%s' in a wrong context : e.g., slicer, sub-select, static category.
Code        : 0xaefeb1a3


### OLAP_CATEGORY_CYCLE

Description : Raised when a category member is creating a cycle.
Code        : 0xdfc96389


### OLAP_AGGREGATE_MULTI_TYPE

Description : Raised when attempting to aggregate values with different aggregation operator.
Code        : 0x11b30bec


### OLAP_TO_STR_MAX_SIZE

Description : Raised when generating a string that exceeds the maximum authorized size (see icCube.toStrMaxSize XMLA property).
Code        : 0xf6d9918a


### OLAP_MDX_FUNCTION_USAGE

Description : Raised when attempting to use a non authorized function (e.g.,  CONSTRAINED context).
Code        : 0x8a01c66e


### OLAP_MDX_FUNCTION_UNRESOLVED

Description : Raised when attempting to use a non existing function.
Code        : 0x1ecb28a


### OLAP_EXTRACT_MISSING_HIERARCHY

Description : Raised when extracting (i.e., .Extract() function) members from missing hierarchies.
Code        : 0x1ebc7329


### OLAP_INVALID_TUPLE_DIMENSIONALITY

Description : Raised when attempting to use tuple with different dimensionality (e.g., when creating a set).
Code        : 0xce3b70b5


### OLAP_DUPLICATED_SOLVE_ORDER

Description : Raised when specifying several calculated members with the same SOLVE_ORDER leading to non predictable results (see icCube.duplicatedSolveOrderError XMLA property).
Code        : 0xcea05c6b


### OLAP_CALC_MEMBER_OVERWRITE_MEMBER

Description : Raised when defining a calculated member with the same unique name as an existing member.
Code        : 0x9bbe9510


### OLAP_MDX_EXPRESSION_EXPECTED

Description : Raised when an empty/null string expression is used (e.g., .StrToXyz() functions).
Code        : 0x71a5e23f


### OLAP_MDX_IDENTIFIER_ERROR

Description : Raised when specifying an invalid identifier as string parameter (e.g., .Dimensions() function).
Code        : 0xd0783c3


### OLAP_CROSSJOIN_TYPE_MISMATCH

Description : Raised when attempting to crossjoin non-set entities.
Code        : 0x6fea53ff


### OLAP_INVALID_DISTANCE_VALUE

Description : Raised when using a distance (i.e., relative level depth) value being out of range.
Code        : 0xf239e9b2


### OLAP_DIFFERENT_HIERARCHIES

Description : Raised when using members of different hierarchies (e.g., periods like function).
Code        : 0xa403e60a


### OLAP_OUT_OF_RANGE

Description : Raised when an argument is out of range.
Code        : 0x7fc3bf54


### OLAP_DRILLDOWN_INVALID_HIERARCHY

Description : Raised when attempting to drilldown members with an invalid hierarchy.
Code        : 0xd223e8d4


### OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED

Description : Raised when attempting to use a time dimension function on a olap  hierarchy that is not a date time one.
Code        : 0xbd98f512


### OLAP_LEVEL_TYPE_TIME_EXPECTED

Description : Raised when a time level does not have the right type (Year,Quarter,Month,Day,...Hour)
Code        : 0xdf8cd04a


### OLAP_LEVEL_DATETIME_EXPECTED_LEVEL_TYPE

Description : Raised when attempting to use a time dimension function on a time level that is not of a given type.
Code        : 0xf383617


### OLAP_TIME_MISSING_DEFAULT_HIERARCHY

Description : Raised when attempting to use the default time hierarchy and no default time dimension has been defined in the cube.
Code        : 0xc14753b8


### OLAP_TIME_MISSING_DEFAULT_HIERARCHY_X

Description : Raised when attempting to use the default time dimension and no default time dimension has been defined in the cube.
Code        : 0xc7346f1b


### OLAP_TIME_MISSING_DEFAULT_MEMBER

Description : Raised when referencing a non-existing default member from a time hierarchy.
Code        : 0x85001b1f


### OLAP_TIME_MISSING_CURRENT_MEMBER

Description : Raised when referencing a non-existing current member from a time hierarchy.
Code        : 0x6598ca22


### OLAP_TIME_MISSING_LEVEL

Description : Raised when referencing a missing level from a time hierarchy.
Code        : 0xfc6d77d0


### OLAP_UNEXPECTED_SET_COUNT

Description : Raised when a function (e.g., crossjoin, union) call does not defined enough sets.
Code        : 0x100290a


### OLAP_AGGREGATION_NOT_SUPPORTED_FOR_TYPE

Description : Raised when trying to aggregate types which do not implement an aggregation method (e.g. strings)
Code        : 0x623edaf5


### OLAP_NO_AGGREGATION_FOR_COLUMN_TYPE

Description : Raised when aggregating a datasource fact column with undefined aggregation
Code        : 0x9fd16173


### OLAP_INVALID_SOLVE_ORDER

Description : Raised when a calculated member SOLVE_ORDER property value is an invalid MDX expression (i.e., not a numeric expression)
Code        : 0xacb7d3dc


### OLAP_INVALID_CAPTION

Description : Raised when a calculated member CAPTION property value is an invalid MDX expression (i.e., not a string expression)
Code        : 0x63da83d1


### OLAP_INVALID_DISPLAY_FOLDER

Description : Raised when a calculated member DISPLAY_FOLDER property value is an invalid MDX expression (i.e., not a string expression)
Code        : 0x3a338861


### OLAP_INVALID_ASSOCIATED_MEASURE_GROUP

Description : Raised when a calculated member ASSOCIATED_MEASURE_GROUP property value is an invalid MDX expression (i.e., not a string expression)
Code        : 0x6a6c0fba


### OLAP_INVALID_NON_EMPTY_BEHAVIOR

Description : Raised when a calculated member NON_EMPTY_BEHAVIOR property value is an invalid MDX expression (i.e., not a string expression, neither a set)
Code        : 0xca40754e


### OLAP_INVALID_VISIBLE

Description : Raised when a calculated member VISIBLE property value is an invalid MDX expression (i.e., not a numeric expression)
Code        : 0xef1622ed


### OLAP_INVALID_EMPTY_IS_ZERO

Description : Raised when a measure VISIBLE property value is an invalid MDX expression (i.e., not a boolean expression)
Code        : 0xa1fbb61e


### OLAP_INVALID_CACHED

Description : Raised when a calculated member REQUEST_CACHED property value is an invalid MDX expression (boolean, numeric, string literals are expected)
Code        : 0xbf724c94


### OLAP_INVALID_SCOPE_ISOLATION

Description : Raised when a calculated member SCOPE_ISOLATION property value is an invalid MDX expression (CUBE is expected)
Code        : 0xaeb65d78


### OLAP_INVALID_AGGREGATION_TYPE

Description : Raised when the AGGREGATION property value is invalid (expect an aggregation type with no hierarchy rollup)
Code        : 0x4e213710


### OLAP_INVALID_ADD_CHILDREN

Description : Raised when a category member ADD_CHILDREN property value is an invalid MDX expression (boolean is expected)
Code        : 0xc1acf8e4


### OLAP_INVALID_DEFAULT_MEMBER_NAME

Description : Raised when a category member DEFAULT_MEMBER_NAME property value is an invalid MDX expression (string is expected)
Code        : 0x2a309788


### OLAP_INVALID_DEFAULT_MEMBER_NAME_ALL

Description : Raised when a category member DEFAULT_MEMBER_NAME property value is defined as 'All'.
Code        : 0x3498e529


### OLAP_INVALID_LEVEL_NAME_PATTERN

Description : Raised when a category member LEVEL_NAME_PATTERN property value is an invalid MDX expression (string is expected)
Code        : 0x9e60ece


### OLAP_INVALID_DESCRIPTION

Description : Raised when a category member DESCRIPTION property value is an invalid MDX expression (string is expected)
Code        : 0x2d611b6d


### OLAP_PROPERTY_TYPE_MISMATCH

Description : Raised when the processing of a property generates a value with the wrong type.
Code        : 0x3b4ef5f5


### OLAP_TYPE_MISMATCH

Description : Raised when the processing generates a value with the wrong type.
Code        : 0xfbbc25a8


### OLAP_DESCENDANTS_INVALID_LEVEL

Description : Raised in the Descendants() method for not matching hierarchies between member and level.
Code        : 0xc6a89f8c


### OLAP_NAMED_SET_NOT_IN_SCOPE

Description : Raised when attempting to access a named set (e.g., with current/currentMember) that is not in the visible scope.
Code        : 0xe6bd7215


### OLAP_CURRENT_ITERATED_TUPLE_USAGE

Description : Raised when the current iterated tuple is used in a context that forbids its usage.
Code        : 0x424f3013


### OLAP_MISSING_ROLLUP_HIERARCHY

Description : Raised when attempting to rollup a measure according in a cube without specified rollup hierarchy (e.g. no default time dimension for an OPEN measure).
Code        : 0x6a88b141


### OLAP_AGGREGATE_TYPE_NOT_SUPPORTED

Description : Aggregate function : raised when using unsupported aggregation type.
Code        : 0xfcbe21f1


### OLAP_SLICER_AGGREGATE_TYPE_NOT_SUPPORTED

Description : Slicer : raised when using unsupported aggregation type.
Code        : 0x30631278


### OLAP_SCHEMA_MISSING

Description : Raised when a schema is not specified to an operation requiring a schema.
Code        : 0xc3cbc9c


### OLAP_FACTLESS_CUBE_EVAL_TUPLE

Description : Raised when an expression is attempting to evaluate a tuple and no fact (i.e., cube) is available.
Code        : 0x5b65fdc


### OLAP_FACTLESS_CUBE_EVAL_TUPLE_EX

Description : Raised when an expression is attempting to evaluate a tuple and no fact (i.e., cube) is available.
Code        : 0xebad496a


### OLAP_DRILLTHROUGH_NOT_AUTHORIZED

Description : Raised when attempting to use non-authorized DRILLTHROUGH.
Code        : 0x54e9b718


### OLAP_DRILLTHROUGH_INVALID_MAXROWS

Description : Raised when an invalid DRILLTHROUGH MAXROWS value is used (note that a positive value is expected).
Code        : 0x7a0a9e40


### OLAP_DRILLTHROUGH_UNKNOWN_RETURN_FUNCTION

Description : Raised when an unknown DRILLTHROUGH RETURN function is specified (e.g., identifier, Name(), UniqueName(), Key(), etc...).
Code        : 0xf4e52b4


### OLAP_DRILLTHROUGH_FUNCTION_UNEXPECTED_ARGUMENT_COUNT

Description : Raised when an unexpected number of arguments is passed to a DRILLTHROUGH RETURN instruction.
Code        : 0x55fc0e6a


### OLAP_DRILLTHROUGH_FUNCTION_DIM_ARGUMENT_TYPE_MISMATCH

Description : Raised when an function used in a DRILLTHROUGH RETURN instruction received as first argument a non-dimension entity.
Code        : 0x3a535547


### OLAP_DRILLTHROUGH_KEY_PART_TYPE_MISMATCH

Description : Raised when a non numerical value is passed to the DRILLTHROUGH RETURN instruction Key().
Code        : 0xbc7fb2f8


### OLAP_DRILLTHROUGH_KEY_PART_INVALID_VALUE

Description : Raised when a invalid numerical value is passed to the DRILLTHROUGH RETURN instruction Key().
Code        : 0xb6b456d2


### OLAP_DRILLTHROUGH_DIM_ATTRIBUTE_TYPE_MISMATCH

Description : Raised when the attribute specified in a DRILLTHROUGH instruction is not a dimension.
Code        : 0x38cd68c


### OLAP_DRILLTHROUGH_MULTI_CELL_WITH_MEASURES

Description : Raised when RETURN [Measures] is specified for a multi-cell (or calc-member) DRILLTHROUGH.
Code        : 0x5671aca2


### OLAP_DRILLTHROUGH_MULTI_CELL_WITH_MEASURE

Description : Raised when RETURN [Measures].[measure-name] is specified for a multi-cell (or calc-member) DRILLTHROUGH.
Code        : 0xcd02f140


### OLAP_DRILLTHROUGH_SINGLE_CELL_WITH_CALC_MEMBER

Description : Raised when a single cell DRILLTHROUGH RETURN a calc-member field.
Code        : 0x1a122ef2


### OLAP_DRILLTHROUGH_SINGLE_CELL_WITH_CELL

Description : Raised when a single cell DRILLTHROUGH RETURN a cell field.
Code        : 0xf96028cf


### OLAP_DRILLTHROUGH_DIM_NOT_LINKED_TO_MEASURE

Description : Raised when a DRILLTHROUGH RETURN a dimension not linked to the returned measure.
Code        : 0x8da25269


### OLAP_DRILLTHROUGH_MEASURE_NOT_LINKED_TO_MEASURE

Description : Raised when a DRILLTHROUGH RETURN a measure not in the measure group of the returned measure.
Code        : 0x6922a7d3


### OLAP_PERSPECTIVE_EVAL_UNEXPECTED_RESULT

Description : Raised the evaluation of a perspective expression is not a non-scalar MDX entity (actual:%s)
Code        : 0xc326cd3


### OLAP_SCHEMA_READ_ONLY

Description : Raised when attempting to modify a read-only schema (e.g., create/drop statement).
Code        : 0x8208d4c8


### OLAP_CUBE_READ_ONLY

Description : Raised when attempting to modify a read-only cube (e.g., create/drop statement).
Code        : 0xa64126fc


### OLAP_SET_FORMULA_INFINITE_LOOP

Description : Raised when the evaluation of a set is entering an infinite loop.
Code        : 0xcc434e13


### OLAP_CALC_MEASURE_MISSING_CUBE

Description : Raised when the declaration of a (calculated) measure does not specify any cube.
Code        : 0x31b95ba8


### OLAP_CALC_MEASURE_MISSING_NAME

Description : Raised when the declaration of a calculated measure does not specify its name.
Code        : 0x5f649416


### OLAP_CURRENT_CELL_VALUE_CONTEXT_ERROR

Description : Raised when the function CurrentCellValue() is used outside the context of a cell property evaluation.
Code        : 0xc60b7c0f


### OLAP_RGB_INVALID_VALUE

Description : Raised when using an invalid RGB value.
Code        : 0x220df22f


### OLAP_JAVA_MODULE_NOT_ACTIVE

Description : Raised when the Java module is called and is not active.
Code        : 0x5eff27d4


### OLAP_JAVA_CLASS_UNKNOWN

Description : Raised when attempting to use an unknown Java class.
Code        : 0xdeb477a7


### OLAP_METHOD_MODULE_NAME_INVALID

Description : Raised when the name of a module is invalid.
Code        : 0x98673a4e


### OLAP_METHOD_NAME_INVALID

Description : Raised when the name of a method is invalid.
Code        : 0xe43c8ceb


### OLAP_METHOD_CLASS_UNKNOWN

Description : Raised when attempting to use an unknown class.
Code        : 0xde14e8ee


### OLAP_METHOD_CLASS_AMBIGUOUS

Description : Raised when attempting to use a class without its full package name.
Code        : 0x76de5914


### OLAP_METHOD_FIELD_UNKNOWN

Description : Raised when attempting to use an unknown field.
Code        : 0xf545aab2


### OLAP_METHOD_UNKNOWN

Description : Raised when attempting to use an unknown method.
Code        : 0xd092aebb


### OLAP_METHOD_EXEC_ERROR

Description : Raised when the execution of a method has generated an error.
Code        : 0xa63d54f


### OLAP_METHOD_EXEC_PARAM_ERROR

Description : Raised when a method parameter could not be converted.
Code        : 0x2c8aab81


### OLAP_NATIVE_METHOD_EXEC_ERROR

Description : Raised when the execution of a native function has generated an error.
Code        : 0x1424cd87


### OLAP_HIERARCHY_MISSING_DEFAULT_MEMBER

Description : Raised when a default member is not available in a hierarchy.
Code        : 0xcbcc8cd8


### OLAP_LANGUAGE_TYPE_MISMATCH

Description : Raised when the evaluation of the LANGUAGE cell property returns an unexpected type.
Code        : 0xdfaa339a


### OLAP_LANGUAGE_IDENTIFIER_UNSUPPORTED

Description : Raised when the evaluation of the LANGUAGE cell property returns an unknown value.
Code        : 0x1d1c4306


### OLAP_COMMAND_UNKNOWN

Description : Raised when executing an unknown command.
Code        : 0xbd0cf395


### OLAP_COMMAND_PARAM_ERROR

Description : Raised when unexpected command parameter(s) is(are) used.
Code        : 0xac866ec7


### OLAP_PERSPECTIVE_DUPLICATED_DIMENSION_RENAME

Description : Raised when renaming several times a dimension
Code        : 0x9c713628


### OLAP_PERSPECTIVE_MULTIPLE_DIMENSION_RENAME

Description : Raised when renaming several dimensions with the same name
Code        : 0x9f98e431


### OLAP_PERSPECTIVE_EXISTING_DIMENSION_RENAME

Description : Raised when renaming a dimension using an existing dimension name
Code        : 0xfd64725b


### OLAP_PERSPECTIVE_DUPLICATED_HIERARCHY_RENAME

Description : Raised when renaming a hierarchy several times
Code        : 0x7759ded7


### OLAP_PERSPECTIVE_MULTIPLE_HIERARCHY_RENAME

Description : Raised when renaming several hierarchies of a given dimension with the same name
Code        : 0x74b00cce


### OLAP_PERSPECTIVE_EXISTING_HIERARCHY_RENAME

Description : Raised when renaming a hierarchy using an hierarchy dimension name
Code        : 0x164c9aa4


### OLAP_PERSPECTIVE_DUPLICATED_LEVEL_RENAME

Description : Raised when renaming a level several times
Code        : 0x64afa8ee


### OLAP_PERSPECTIVE_MULTIPLE_LEVEL_RENAME

Description : Raised when renaming several levels of a given hierarchy with the same name
Code        : 0x44d41ed6


### OLAP_PERSPECTIVE_EXISTING_LEVEL_RENAME

Description : Raised when renaming a level using an existing level name
Code        : 0x7f88e9c0


### OLAP_PERSPECTIVE_DUPLICATED_MEMBER_RENAME

Description : Raised when renaming a member several times
Code        : 0x872d1974


### OLAP_PERSPECTIVE_MULTIPLE_MEMBER_RENAME_LEVEL

Description : Raised when renaming (in level) several members with the same name
Code        : 0xd5c84740


### OLAP_PERSPECTIVE_EXISTING_MEMBER_RENAME_LEVEL

Description : Raised when renaming (in level) a member using an existing member name
Code        : 0x3989a7f


### OLAP_PERSPECTIVE_MULTIPLE_MEMBER_RENAME_PARENT

Description : Raised when renaming (in parent) several members with the same name
Code        : 0xf4cd6242


### OLAP_PERSPECTIVE_EXISTING_MEMBER_RENAME_PARENT

Description : Raised when renaming (in parent) a member using an existing member name
Code        : 0x427d1fa2


### OLAP_MISSING_MONITORING_BIGBROTHER

Description : Raised when a request for monitoring is made without the module being active in the current session.
Code        : 0x52338ed2


### OLAP_LEVEL_LOOKUP_BY_KEY_TYPE_MISMATCH

Description : Raised when performing a lookup by key within a level with value of wrong type
Code        : 0x51e263a5


### OLAP_SUB_CUBE_UNEXPECTED_CALCULATED_MEMBER

Description : Raised when a calculated measure/member cannot be used in a sub-cube definition
Code        : 0x20e34962


### OLAP_SUB_CUBE_UNEXPECTED_MEASURE_MEMBER

Description : Raised a measure cannot be used in a sub-cube definition
Code        : 0x5fc5eb3e


### OLAP_DATE_PARSING_ERROR

Description : Raised when a date can not be parsed
Code        : 0xfc1c4bee


### OLAP_DEFINE_DEFAULT_MEMBER_TYPE_MISMATCH

Description : Raised when DEFINE_DEFAULT_MEMBER is referencing a non member entity
Code        : 0xa7c3eaf9


### OLAP_IMPERSONATION_ROLE_UNKNOWN

Description : Raised when requesting an unknown role for impersonation
Code        : 0xa5e38194


### OLAP_ALERT_EVAL_ERROR

Description : Raised when an alert formula cannot be evaluated on success.
Code        : 0x64b4e9a0


### OLAP_ALERT_TYPE_MISMATCH

Description : Raised when an alert formula cannot be evaluated as a boolean expression.
Code        : 0x600b93f4


### OLAP_ALERT_MISSING_CUBE

Description : Raised when an alert references a cube that does not exist.
Code        : 0xc5100092


### OLAP_ALERT_CUBE_UNSPECIFIED

Description : Raised when an alert does not reference any cube and the schema contains more than one cube.
Code        : 0x8b957ec8


### OLAP_CONST_FUNCTION_USAGE

Description : The description is not available.
Code        : 0xcac8a62f


### OLAP_NON_EMPTY_BEHAVIOR_ERROR

Description : Raised when the non empty behavior cannot be determined
Code        : 0x1564bea0


### OLAP_STATIC_FUNCTION_MISSING_CUBE

Description : Raised when a static function attempts to evaluate a tuple with no cube defined
Code        : 0x3cf57ca5


### OLAP_NATIVE_FUNCTION_ERROR

Description : Raised when an expected error occurs during the evaluation of a native function.
Code        : 0xfb3fce58


### OLAP_JAVA_NATIVE_FUNCTION_COMPILATION_ERROR

Description : Raised when an error occurs during the compilation of a JAVA native function.
Code        : 0x5bbf404


### OLAP_MEASURE_MULTIPLE_MEASURE_GROUPS

Description : Raised when a user defined measure reference measures from multiple measure groups
Code        : 0xc1bd2f5f


### OLAP_MEASURE_MISSING_MEASURES

Description : Raised when a user defined measure does not reference any measure
Code        : 0x6290da2


### OLAP_MEASURE_FORMULA_NOT_SUPPORTED

Description : Raised when using a formula within a user defined measure
Code        : 0x36b9ec03


### OLAP_MEASURE_FORMULA_MISSING_AGGREGATION

Description : Raised a user defined meausure does not define its AGGREGATION property
Code        : 0x7da95837


### OLAP_CONTEXT_MEMBER_MULTIPLE_MEMBERS

Description : Raised when context members returns more than one member
Code        : 0x9a0d31de


### OLAP_DEBUGGER_SCRIPT_ERROR

Description : Raised when debugging a multi-statement MDX script.
Code        : 0x40c70406


### OLAP_NEUTRAL_ELEMENT_MISMATCH

Description : Raised when then neutral element (∅) is used in a wrong context.
Code        : 0x63e44147


### OLAP_UNEXPECTED_TUPLE_EVALUATION

Description : Raised when attempting to evaluate a tuple.
Code        : 0x2a05482c


### OLAP_IC3_RUN_MDX_ERROR

Description : Raised by the evaluation of ic3run exec mdx-expr statement.
Code        : 0x84fce5b8


### OLAP_SET_MATERIALIZATION_LIMIT

Description : Raised when a set cannot be materialized (size limit exceeded).
Code        : 0x347776ee


### OLAP_TIDY_ON_AXES_NOT_SUPPORTED

Description : Raised when using on Axes with tidy table result.
Code        : 0x642f0c49


### OLAP_TIDY_AXIS_MATERIALIZATION_LIMIT

Description : Raised when the axis cannot be materialized.
Code        : 0x81a649d1


### OLAP_TIDY_AXIS_MATERIALIZATION_LIMIT_NE

Description : Raised when the axis cannot be materialized.
Code        : 0x62a8ca1c


### OLAP_TIDY_AXIS_0_NOT_MATERIALIZED

Description : Raised when the axis 0 cannot be materialized.
Code        : 0x4ee90c8a


### OLAP_TIDY_AXIS_MEASURES_NOT_MATERIALIZED

Description : Raised when the last axis cannot be materialized.
Code        : 0x4208d0c7


### OLAP_TIDY_AXIS_0_SIZE_ERROR

Description : Raised when the axis 0 is too large.
Code        : 0xfab4430c


### OLAP_TIDY_AXIS_MEASURES_SIZE_ERROR

Description : Raised when the last axis (#measures) is too large.
Code        : 0x44c540be


### OLAP_TIDY_AXIS_0_MEASURES_SIZE_ERROR

Description : Raised when the size of the axis 0 and last axis (#measures) is too large.
Code        : 0xdb56623


### OLAP_REGEX_ERROR

Description : Raised when a regular expression is invalid.
Code        : 0x5a7472ef


### OLAP_DEPRECATED

Description : Raised when using a deprecated feature.
Code        : 0x8396326a


### OLAP_TUPLE_LIST_COUNT

Description : Raised when a list of tuple exceeds its maximum size.
Code        : 0xcc506176


### OLAP_DUPLICATED_ITERATION

Description : Raised when a function is iterated more than once.
Code        : 0x9389d632


### OLAP_TABLE_AGGR_MISSING

Description : Raised when a referenced table aggregator is not found.
Code        : 0xafb8e297


### OLAP_TABLE_AGGR_MEASURE_UNKNOWN

Description : Raised when a table aggregator is referencing an unknown measure
Code        : 0x1a99b679


### OLAP_TABLE_AGGR_MEASURE_TYPE_MISMATCH

Description : Raised when a table aggregator is not referencing a measure entity
Code        : 0x469b36f5


### OLAP_SET_SIZE_MISMATCH

Description : Raised when two sets do not have the same size
Code        : 0xdd9c00b8


### OLAP_REGULAR_MEASURE_MISMATCH

Description : Raised when a non-regular measure is used as second parameter
Code        : 0x43fdce60


### OLAP_UNEXPECTED_CALC_MEMBER

Description : Raised when NonEmptyMembers is used with a calculated member
Code        : 0xedb6f822


### OLAP_NO_EMPTY_MEMBERS_DIMENSIONALITY_MISMATCH

Description : Raised when the NonEmptyMembers set dimensionality intersects with the measure dimensionality
Code        : 0x55afb76d


### OLAP_TPP_DIMENSION_PROPERTIES_ARG_MISMATCH

Description : Raised when the DimensionProperties tidy post processor receive an unexpected argument.
Code        : 0x476c199a


### OLAP_TPP_DIMENSION_PROPERTIES_HIERARCHY_UNKNOWN

Description : Raised when the DimensionProperties tidy post processor references an unknown hierarchy
Code        : 0x303c09f4


### OLAP_TPP_DIMENSION_PROPERTIES_PROPERTY_UNKNOWN

Description : Raised when the DimensionProperties tidy post processor references an unknown property
Code        : 0x5518ec96


_