## dtWithTime

Returns the member changing the current member's time (hour and minute).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|hour [0-24] |numeric-expression |one | |
|minute [0-60] |numeric-expression |one | |



### Return

```
member
```



### Description

This functions returns a member changing the current member's time.

dtWithTime( [Time].[Calendar].[Day].[6 Jun 2006], 0,0 ) will return the 6th of June 2007 as the dimension has no time information.



### Since Version

6.0


                                                
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithTime(NULL,numeric) - return NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the first parameter is NULL or an empty entity.

**Query**

```
dtWithTime(NULL,12,50)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithTime(member,numeric) - member not of level hour

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtWithTime([Calendar].[Year].[2016],1,1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_EXPECTED_LEVEL_TYPE](icCubeError.md#olap_level_datetime_expected_level_type)</td></tr><tr><td>Error Message</td><td>

dtWithTime() : The level ('[Calendar].[Calendar].[Year]') is expected to be of type 'HOUR' (got :'[DATE]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithTime(member,numeric) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtWithTime([Geography].[Geo].[Paris],1,1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtWithTime() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

                                                                         

### See Also


[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
