## dtWithDayOfWeek

Returns the member changing the current member's day of the week.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|day of the week [1-7] |numeric-expression |one | |



### Return

```
member
```



### Description

This functions returns a member changing the current member's day of the week.

dtWithDayOfWeek( [Time].[Calendar].[Day].[6 Jun 2006], 5 ) will return the 9th that is the Friday of the week.



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithDayOfWeek(member,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member defined by the Tuesday of the week defined by the 17th November 2016.

**Query**

```
dtWithDayOfWeek([Calendar].[Day].[17 Nov 2016],2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-11-15]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Calendar].[Day].[15 Nov 2016]
```


**Assertion : MDX Equals**

```
[Calendar].[Day].[17 Nov 2016].dtWithDayOfWeek(2)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithDayOfWeek(NULL,numeric) - return NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the first parameter is NULL or an empty entity.

**Query**

```
dtWithDayOfWeek(NULL,2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithDayOfWeek(member,numeric) - out of bounds

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if the day of the month is out of bounds

**Query**

```
dtWithDayOfWeek([Calendar].[Day].[23 Feb 2016],8)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_ERROR](icCubeError.md#olap_function_argument_error)</td></tr><tr><td>Error Message</td><td>

dtWithDayOfWeek() : argument (1) error: 'The parameter should in the range [1,7], got : 8'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithDayOfWeek(member,numeric) - member not of level day

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtWithDayOfWeek([Calendar].[Month].[2016 Jan],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_EXPECTED_LEVEL_TYPE](icCubeError.md#olap_level_datetime_expected_level_type)</td></tr><tr><td>Error Message</td><td>

dtWithDayOfWeek() : The level ('[Calendar].[Calendar].[Month]') is expected to be of type 'DAY' (got :'[DATE]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtWithDayOfWeek(member,numeric) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtWithDayOfWeek([Geography].[Geo].[Paris],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtWithDayOfWeek() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

                                                                         

### See Also


[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
