## dtMinusWeeks

Returns the member matching current member minus 'count' number of weeks.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|time member |set-member-expression |one | |
|count |numeric-expression |one | |



### Return

```
member|set-members
```



### Description

Returns the member matching current member minus 'count' number of weeks.
If the member is missing it will return NULL.

dtMinusWeeks( [Time].[Calendar].[Day].[10 Jun 2006], 1 ) will return [Time].[Calendar].[Day].[3 Jun 2006]

When applied to a set it will return a set that is the result of applying this function on each member
of the input set. When the resulting member is missing it will be ignored.



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(member,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member matching two weeks before the 20th June.

**Query**

```
dtMinusWeeks([Calendar].[Day].[20 Jun 2016],2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-06-06]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Calendar].[Day].[6 Jun 2016]
```


**Assertion : MDX Equals**

```
[Calendar].[Day].[20 Jun 2016].dtMinusWeeks(2)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with the member matching two weeks before each member of the parameter set.

**Query**

```
dtMinusWeeks({[Calendar].[Day].[20 Jun 2016],[Calendar].[Day].[20 Jun 2017]},2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-06-06], 
  [Calendar].[Calendar].[Day].&[2017-06-06]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[Day].[6 Jun 2016],[Calendar].[Day].[6 Jun 2017]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(member,numeric) - returns NULL if the lookup member is missing

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the 'lookup' member is missing.

**Query**

```
dtMinusWeeks([Calendar].[Day].[1 Jan 2016],2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(set,numeric) - missing lookup members are ignored

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with the member matching two weeks before each member of the parameter set, ignoring any member that is missing.

**Query**

```
dtMinusWeeks({[Calendar].[Day].[1 Jan 2016],[Calendar].[Day].[20 Jun 2017]},2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2017-06-06]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Calendar].[Day].[6 Jun 2017]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(NULL,numeric) - return NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the first parameter is NULL or an empty entity.

**Query**

```
dtMinusWeeks(NULL,1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(member,numeric) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtMinusWeeks([Geography].[Geo].[Paris],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtMinusWeeks() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtMinusWeeks(member,numeric) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtMinusWeeks({[Geography].[Geo].[Paris]},1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtMinusWeeks() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

                                                                         

### See Also


[Lag](Lag.md)

[dtAsOf](dtAsOf.md)

[dtAsOfToday](dtAsOfToday.md)

[dtNextDay](dtNextDay.md)

[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
