## dtLastDayOfWeekOfQuarter

Returns the member matching the last day of the week of the quarter (e.g. last Saturday), null if missing.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|time member |set-member-expression |one | |
|day of week [1-7] |numeric-expression |one | |



### Return

```
member|set-members
```



### Description

This functions returns the member matching the last day of the week of the quarter.
If the member is missing it will return NULL.

dtLastDayOfWeekOfQuarter( [Calendar].[Calendar].[Day].[30 Nov 2016], 7 ) will return the last Sunday of the quarter (i.e., [Time].[Calendar].[Day].[25 Dec 2016]).

When applied to a set it will return a set that is the result of applying this function on each member
of the input set. When the resulting member is missing it will be ignored.



### Since Version

6.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtLastDayOfWeekOfQuarter(member,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last Monday of March.

**Query**

```
dtLastDayOfWeekOfQuarter( [Calendar].[Day].[15 Jan 2016], 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-03-28]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Calendar].[Day].[28 Mar 2016]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtLastDayOfWeekOfQuarter(set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last Monday of March and June.

**Query**

```
dtLastDayOfWeekOfQuarter( { [Calendar].[Day].[15 Jan 2016], [Calendar].[Day].[15 Apr 2016] }, 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-03-28], 
  [Calendar].[Calendar].[Day].&[2016-06-27]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Calendar].[Day].[28 Mar 2016], [Calendar].[Day].[27 Jun 2016] }
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtLastDayOfWeekOfQuarter(NULL,numeric) - return NULL

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the first parameter is NULL or an empty entity.

**Query**

```
dtLastDayOfWeekOfQuarter( NULL, 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtLastDayOfWeekOfQuarter(member,numeric) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error when the member is not a date/time.

**Query**

```
dtLastDayOfWeekOfQuarter( [Geography].[Geo].[Paris], 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtLastDayOfWeekOfQuarter() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtNextDay(set,numeric) - member not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error when the members are not a date/time.

**Query**

```
dtLastDayOfWeekOfQuarter( { [Geography].[Geo].[Paris] }, 1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtLastDayOfWeekOfQuarter() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

                                                                         

### See Also


[dtAsOf](dtAsOf.md)

[dtAsOfToday](dtAsOfToday.md)

[dtNextDay](dtNextDay.md)

[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
