## dtAsOf

Returns the member matching the current day or daytime.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|date |date-expression |one | |



### Return

```
member
```



### Description

This functions returns a member matching the year, month and day of the parameters

dtAsOf( [Time].[Calendar].[Day], 2008, 10, 25 ) , note that both day and month start at 1

This function is very similar to LookupByKey



### Since Version

6.7.5


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtAsOf(hierarchy, date)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member matching 28 Mar 2016.

**Query**

```
dtAsOf([Calendar].[Day], DateTime(2016,3,28))
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Calendar].[Calendar].[Day].&[2016-03-28]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Calendar].[Day].[28 Mar 2016]
```


**Assertion : MDX Equals**

```
lookupByKey([Calendar].[Day], DateTime(2016,3,28))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtAsOf(hierarchy,date) - NULL if no matching member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL as there is no member matching the input date in the [Calendar] hierarchy

**Query**

```
dtAsOf([Calendar].[Day],DateTime(1982,3,28))
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dtAsOf(hierarchy,numeric) - not a date time type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to a hierarchy that is not a data time one.

**Query**

```
dtAsOf([Geography].[Geo], Today())
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_LEVEL_DATETIME_KEYTYPE_EXPECTED](icCubeError.md#olap_level_datetime_keytype_expected)</td></tr><tr><td>Error Message</td><td>

dtAsOf() : The level ('[Geography].[Geo].[City]') is expected with a date or date time key type (got :'[STRING]')</td></tr></table>


 
</div>

                                                                         

### See Also


[CompactSet](CompactSet.md)

[LookupByKey](LookupByKey.md)

[dtAsOf](dtAsOf.md)

[dtAsOfToday](dtAsOfToday.md)

[dtNextDay](dtNextDay.md)

[dtNextWeek](dtNextWeek.md)

[dtNextMonth](dtNextMonth.md)

[dtNextQuarter](dtNextQuarter.md)

[dtNextYear](dtNextYear.md)

[dtPreviousDay](dtPreviousDay.md)

[dtPreviousWeek](dtPreviousWeek.md)

[dtPreviousMonth](dtPreviousMonth.md)

[dtPreviousQuarter](dtPreviousQuarter.md)

[dtPreviousYear](dtPreviousYear.md)

[dtPlusDays](dtPlusDays.md)

[dtPlusWeeks](dtPlusWeeks.md)

[dtPlusMonths](dtPlusMonths.md)

[dtPlusQuarters](dtPlusQuarters.md)

[dtPlusYears](dtPlusYears.md)

[dtMinusDays](dtMinusDays.md)

[dtMinusWeeks](dtMinusWeeks.md)

[dtMinusMonths](dtMinusMonths.md)

[dtMinusQuarters](dtMinusQuarters.md)

[dtMinusYears](dtMinusYears.md)

[dtFirstDayOfWeekOfMonth](dtFirstDayOfWeekOfMonth.md)

[dtFirstDayOfWeekOfQuarter](dtFirstDayOfWeekOfQuarter.md)

[dtFirstDayOfWeekOfYear](dtFirstDayOfWeekOfYear.md)

[dtLastDayOfWeekOfMonth](dtLastDayOfWeekOfMonth.md)

[dtLastDayOfWeekOfQuarter](dtLastDayOfWeekOfQuarter.md)

[dtLastDayOfWeekOfYear](dtLastDayOfWeekOfYear.md)

[dtNthDayOfWeekOfMonth](dtNthDayOfWeekOfMonth.md)

[dtNthDayOfWeekOfQuarter](dtNthDayOfWeekOfQuarter.md)

[dtNthDayOfWeekOfYear](dtNthDayOfWeekOfYear.md)

[dtDatesWeek](dtDatesWeek.md)

[dtDatesWeekend](dtDatesWeekend.md)

[dtDatesWorkweek](dtDatesWorkweek.md)

[dtDatesWtd](dtDatesWtd.md)

[dtDatesMtd](dtDatesMtd.md)

[dtDatesQtd](dtDatesQtd.md)

[dtDatesYtd](dtDatesYtd.md)

[dtDatesItd](dtDatesItd.md)

[dtDatesWfd](dtDatesWfd.md)

[dtDatesMfd](dtDatesMfd.md)

[dtDatesQfd](dtDatesQfd.md)

[dtDatesYfd](dtDatesYfd.md)

[dtWithDayOfWeek](dtWithDayOfWeek.md)

[dtWithDayOfMonth](dtWithDayOfMonth.md)

[dtWithDayOfYear](dtWithDayOfYear.md)

[dtWithMonthOfYear](dtWithMonthOfYear.md)

[dtWithYear](dtWithYear.md)

[dtWithTime](dtWithTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
