## VISIBLE

Controls the visibility of a calculated member.




### Description

A nonzero value indicates that the calculated member is visible. The default value for this property is visible.

Calculated members that are not visible are typically used as intermediate steps in more complex calculated
members. Non-visible calculated members are for example not listed in `AddCalculatedMembers`, `AllMembers`
functions.

If you need to control the visibility of a regular measure (or any other member), you can use
[perspectives](../../user_guide/schemas_cubes/adv_perspectives.md).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Invisible : Accessible

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, [Measures].[X] is used as an intermediate calculated member to compute Y.

**Query**

```
WITH
    MEMBER [Measures].[X] AS 42, VISIBLE = 0
    MEMBER [Measures].[Y] AS 2 * [Measures].[X]

    SELECT Y ON 0 FROM SALES
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Y</td>
</tr>
<tr>
 <td>84</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH MEMBER Y AS 2 * 42
SELECT Y ON 0 FROM SALES
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Invisible : Not Listed

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, the invisible [Measures].[X] is not listed by AddCalculatedMembers whereas [Measures].[Y] is listed.

**Query**

```
WITH
    MEMBER [Measures].[X] AS 42, VISIBLE = 0
    MEMBER [Measures].[Y] AS 42, VISIBLE = 1

    MEMBER [Measures].[X Contained] AS IsIn( AddCalculatedMembers( [Measures] ), [Measures].[X] )
    MEMBER [Measures].[Y Contained] AS IsIn( AddCalculatedMembers( [Measures] ), [Measures].[Y] )

SELECT { [Measures].[X Contained], [Measures].[Y Contained] } ON 0 FROM SALES
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">X Contained</td>
  <td class="ic3-mdx-result-cell-header">Y Contained</td>
</tr>
<tr>
 <td>false</td>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[X Contained] AS false
    MEMBER [Measures].[Y Contained] AS true

SELECT { [Measures].[X Contained], [Measures].[Y Contained] } ON 0 FROM SALES
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](../Cell%20Properties.md)

[LANGUAGE](LANGUAGE.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
