## STYLE

Defines HML/CSS properties to be used for cell rendering.




### Description

The `STYLE` cell property matches the corresponding CSS attributes and can take any valid CSS string.
If the `STYLE` property is not defined by the cell, regular properties (`BACK_COLOR`, `FONT_FLAGS`, `FONT_NAME`,
`FONT_SIZE`, `FORE_COLOR`) are translated to the CSS equivalent to set the `STYLE` property.

This property is directly compatible with Google Visualization Table and icCube Pivot Table charts.

`MEMBER [MyMeasure] AS mdx-expression, STYLE = 'font: 75% georgia, sans-serif;color: #B7A5DF;margin: 0;'`



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### STYLE - defined using FORE_COLOR

</div>

<div class="ic3-mdx-example-body" style="display:none">

Example how FORE_COLOR and BACK_COLOR is used to set the STYLE property.

**Query**

```
WITH
    MEMBER [test] AS 1, FORE_COLOR = RGB(64,128,0), BACK_COLOR = RGB(180,180,180)
SELECT
    {[test]} on 0
FROM sales
CELL PROPERTIES VALUE,STYLE -- we request style property, even though not directly defined.
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">test</td>
</tr>
<tr>
 <td style='background-color:#B4B4B4;color:#408000;'>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [test] AS 1, STYLE="background-color:#B4B4B4;color:#408000;"
SELECT
    {[test]} on 0
FROM sales
CELL PROPERTIES VALUE,STYLE
```


**Assertion : MDX Equals**

```
WITH
    --  FORE_COLOR is not used to set the STYLE
    MEMBER [test] AS 1, STYLE="background-color:#B4B4B4;color:#408000;", FORE_COLOR = 2121
SELECT
    {[test]} on 0
FROM sales
CELL PROPERTIES VALUE,STYLE
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](../Cell%20Properties.md)

[CLASSNAME](CLASSNAME.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
