## SOLVE_ORDER

SOLVE_ORDER defines the evaluation order of calculated members.




### Description

Please refer to the following [page](../Solve%20Order.md) for a detailed description of the solve order.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Without Solve Order I

</div>

<div class="ic3-mdx-example-body" style="display:none">

Test the evaluation order without defining SOLVE_ORDER property. The first calculated member
            to be evaluated will be [K2] as is the first one.

**Query**

```
WITH
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember)
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember)
 MEMBER [Measures].[Check] as ([Geography].[Geo].[K1],[Geography].[Economy].[K2],[Amount])
SELECT
 {[Check],[Amount]}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>2093058</td>
 <td>1023</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Without Solve Order II

</div>

<div class="ic3-mdx-example-body" style="display:none">

Test the evaluation order without defining SOLVE_ORDER property. The first calculated member
            to be evaluated will be [K1] as is the first one defined.

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember)
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember)
 MEMBER [Measures].[Check] as ([Geography].[Geo].[K1],[Geography].[Economy].[K2],[Amount])
SELECT
 {[Check],[Amount]}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>4186116</td>
 <td>1023</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Without Solve Order : Measures vs. other dimensions

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated measures takes precedence over other calculated members. In our example, even if [Measures].[Check] is declared after [Geography].[Geo].[K1] it is evaluated first.

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as 1
 MEMBER [Measures].[Check] as 2
SELECT
 ( [Geography].[Geo].[K1], [Measures].[Check] ) on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">K1</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### With Solve Order

</div>

<div class="ic3-mdx-example-body" style="display:none">

The first calculated member to be evaluated will the one with the highest value. In our example, [K2]

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember) , SOLVE_ORDER=10
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember) , SOLVE_ORDER=12
 MEMBER [Measures].[Check] as ([Geography].[Geo].[K1],[Geography].[Economy].[K2],[Amount])
SELECT
 {[Check],[Amount]}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>2093058</td>
 <td>1023</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### With Solve Order II - with Measure member

</div>

<div class="ic3-mdx-example-body" style="display:none">

The first calculated member to be evaluated will the one with the highest solve order. In our example the evaluation order is [K2],[K1],[Check].

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember) , SOLVE_ORDER=10
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember) , SOLVE_ORDER=12
 MEMBER [Measures].[Check] as 2, SOLVE_ORDER=2
SELECT
 {([Check],[Geography].[Geo].[K1],[Geography].[Economy].[K2])}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K1</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K2</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### With Solve Order III - with Measure member

</div>

<div class="ic3-mdx-example-body" style="display:none">

The first calculated member to be evaluated will the one with the highest value. In our example, [Check] that stops the evaluation of the other tuple members.

**Query**

```
WITH
 MEMBER [Geography].[Geo].[K1] as ( [Geography].[Geo].defaultMember ) * ( [Geography].[Geo].defaultMember) , SOLVE_ORDER=10
 MEMBER [Geography].[Economy].[K2] as ( [Geography].[Economy].defaultMember ) + ( [Geography].[Economy].defaultMember) , SOLVE_ORDER=12
 MEMBER [Measures].[Check] as 2, SOLVE_ORDER=22
SELECT
 {([Check],[Geography].[Geo].[K1],[Geography].[Economy].[K2])}  on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Check</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K1</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">K2</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



 
</div>

                                                                                                            

### See Also


[Calculated Members](../Calculated%20Members.md)

[Solve Order](../Solve%20Order.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
