## LANGUAGE

Controls how cell formatted values are localized.




### Description

This property defines the locale (language) to apply when generating a localized version of `FORMATTED_VALUE`. For a complete <b>list of languages</b> currently supported by icCube have a look to this [page](../icCubeLanguages.md). It is possible to define a language using the Java locale string. Note, internally it will be translated to the Microsoft Language code (numeric).

<pre>
// for currency in dollars and american format
MEMBER [Amount US] AS [Amount], LANGUAGE=1033, FORMAT_STRING="Currency"
// for currency in euros and UK format
MEMBER [Amount UK] AS [Amount] * [EuroFx] , LANGUAGE=2057, FORMAT_STRING="Currency"
// using Java locale for Germany
MEMBER [Amount Germany] AS [Amount] * [EuroFx] , LANGUAGE="de_DE", FORMAT_STRING="Currency"
</pre>

You might wonder which locale is used if the property is not defined. The icCube engine is going to take the first defined value following this list:
<ol>
<li>cell `LANGUAGE` property
<li>MDX query property (XMLA protocol)
<li>User's default locale
<li>icCube Server locale (always defined)
</ol>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Localized 'Standard' FORMAT_STRING

</div>

<div class="ic3-mdx-example-body" style="display:none">

The request is performed using the US locale. Therefore unless otherwise specified, values are formatted using this US locale. The [French] measure is overriding this locale to have a comma as decimal separator.

**Query**

```
with
  member [English] as 3.14, FORMAT_STRING = 'Standard'
  member [French]  as 3.14, FORMAT_STRING = 'Standard', LANGUAGE = 1036
select { [English], [French] } on 0 from sales cell properties formatted_value
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">English</td>
  <td class="ic3-mdx-result-cell-header">French</td>
</tr>
<tr>
 <td>3.14</td>
 <td>3,14</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
    member [English] as "3.14"
    member [French]  as "3,14"
select { [English], [French] } on 0 from sales cell properties formatted_value
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### JAVA Locale

</div>

<div class="ic3-mdx-example-body" style="display:none">

The LANGUAGE property might be defined using a JAVA locale as well.

**Query**

```
with
  member [English] as 3.14, FORMAT_STRING = 'Standard'
  member [French]  as 3.14, FORMAT_STRING = 'Standard', LANGUAGE = "fr_FR"
select { [English], [French] } on 0 from sales cell properties formatted_value
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">English</td>
  <td class="ic3-mdx-result-cell-header">French</td>
</tr>
<tr>
 <td>3.14</td>
 <td>3,14</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
    member [English] as "3.14"
    member [French]  as "3,14"
select { [English], [French] } on 0 from sales cell properties formatted_value
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Neutral

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this test, the [English] measure is computed from the [French] calculated measure. Therefore, it is inheriting all the cell properties defined in [French]. To reset the LANGUAGE property as if *not* being defined, the value 0 (i.e., neutral) is used and the locale of the request is going to be used; English in that case.

**Query**

```
with
  member [French]  as 3.14    , FORMAT_STRING = 'Standard', LANGUAGE = "fr_FR"
  member [English] as [French], LANGUAGE = 0
select { [English], [French] } on 0 from sales cell properties formatted_value
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">English</td>
  <td class="ic3-mdx-result-cell-header">French</td>
</tr>
<tr>
 <td>3.14</td>
 <td>3,14</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
    member [French]  as "3,14"
    member [English] as "3.14"
select { [English], [French] } on 0 from sales cell properties formatted_value
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](../Cell%20Properties.md)

[FORMAT_STRING](FORMAT_STRING.md)


### XMLA Properties

Find [here](../icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
