## Zip

Combines set of members of same size to a set of tuple.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |two-n | |



### Return

```
set-members
```



### Description

For two or more sets of members combines them to generate a set of tuples (element-wise combination).

Zip( {A,B}, {a,b} ) = {(A,a), (B,b)}



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Zip(set,set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Combines two sets into a set of tuples.

**Query**

```
Zip( {[Geography].[Geo].[Continent].[America]}, {[Calendar].[Day].[8 Jul 2018]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[America], [Calendar].[Calendar].[Day].&[2018-07-08] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Continent].[America], [Calendar].[Day].[8 Jul 2018])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Zip(set,set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

You can combine more than two sets, three in this example.

**Query**

```
Zip( {[Geography].[Geo].[Continent].[America]}, {[Calendar].[Day].[8 Jul 2018]} ,{[Measures].defaultMember})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[America], [Calendar].[Calendar].[Day].&[2018-07-08], [Measures].[Amount] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Continent].[America], [Calendar].[Day].[8 Jul 2018], [Measures].defaultMember)}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Zip - size mismatch

</div>

<div class="ic3-mdx-example-body" style="display:none">

Throws an error is the sets have not the same size

**Query**

```
Zip( {[Geography].[Geo].[Continent].members}, {[Calendar].[Day].[8 Jul 2018]} ,{[Measures].defaultMember})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_SET_SIZE_MISMATCH](icCubeError.md#olap_set_size_mismatch)</td></tr><tr><td>Error Message</td><td>

Zip() : the both sets do not have the same size : [2, 1, 1]</td></tr></table>


 
</div>

                                                                         

### See Also


[Generate](Generate.md)

[LookupByKeys](LookupByKeys.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
