## Ytd

Returns PeriodsToDate( Year_Level, Member ).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |zero-one | |



### Return

```
set
```



### Description

This function is strictly equivalent to: PeriodsToDate(Year_Level, Member).

If no member is defined, then [Time].currentMember is used.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ytd(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Strictly equivalent to: PeriodsToDate( [Time].[Calendar].[Year], member ).

In our example, returns the months of year [2010] stopping at [Mar 2010]

**Query**

```
Ytd([Time].[Calendar].[Mar 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2010], 
  [Time].[Calendar].[Month].[Feb 2010], 
  [Time].[Calendar].[Month].[Mar 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
PeriodsToDate([Time].[Calendar].[Year],[Mar 2010])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ytd()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Strictly equivalent to: PeriodsToDate([ Time].[Calendar].[Year], [Time].currentMember).

**Query**

```
WITH
    MEMBER period_names AS GENERATE(Ytd() as periods, periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>Jan 2010-Feb 2010-Mar 2010-Apr 2010-May 2010-Jun 2010-Jul 2010-Aug 2010</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER period_names AS
    GENERATE(Ytd([Time].[Calendar].CurrentMember) as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ytd(member) - non time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

The function works only with time dimensions.

**Query**

```
Ytd([Geography].[Geo].[Spain].firstChild)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

unexpected hierarchy (expected:'[Time].[Calendar]') (actual:'[Geography].[Geo]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ytd(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set.

**Query**

```
Ytd(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
PeriodsToDate([Time].[Calendar].[Year],NULL)
```


 
</div>

                                                                         

### See Also


[PeriodsToDate](PeriodsToDate.md)

[Wtd](Wtd.md)

[Mtd](Mtd.md)

[Qtd](Qtd.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
