## WAvg

Compute the weighted average value over the specified set, WAvg( Set, Weight, Value ).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|weight |value-expression |one | |
|value |value-expression |one | |



### Return

```
value
```



### Description

The WAvg function calculates the weighted average value of the non-empty cells. Empty cells are ignored.

When the value expression is specified, the measure is evaluated over the set and its weighted average value is returned.

The pseudo code for this algorithm is :

<pre> Weighted Average = WAvg( Set, Weight, Value )

for each member of the set
total_weight = total_weight + weight_i
w_avg = w_avg + weight_i * value_i

wavg = wavg / total_weight </pre>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### WAvg(set,numeric,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the weighted average of the numeric function applied over the tuples of the set.

In our example we're calculating the weighted average with a constant weight of 2.

**Query**

```
WITH
    MEMBER [Measures].[WAvg Amount] AS WAvg( [Geography].[Economy].members, 2, [Measures].[Amount] )
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">WAvg Amount</td>
</tr>
<tr>
 <td>383.625</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[WAvg Amount] AS Avg( [Geography].[Economy].members, [Measures].[Amount] )
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### WAvg(set,numeric,numeric) - II

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the weighted average of the numeric function applied over the tuples of the set.

In our example we're calculating the weighted average with a variable weight.

**Query**

```
WITH
    MEMBER [Measures].[WAvg Amount] AS WAvg( [Geography].[Economy].members, [Measures].[Amount] / 2, [Measures].[Amount] )
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">WAvg Amount</td>
</tr>
<tr>
 <td>765.4802867383513</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[weight] AS ( [Measures].[Amount]  / 2)
    MEMBER [Measures].[value] AS ( [Measures].[Amount]  )
    MEMBER [Measures].[WAvg Amount.1] AS Avg( [Geography].[Economy].members, [Measures].[weight]*[Measures].[value] )
    MEMBER [Measures].[WAvg Amount.2] AS Avg( [Geography].[Economy].members, [Measures].[weight] )
    MEMBER [Measures].[WAvg Amount] AS [Measures].[WAvg Amount.1] / [Measures].[WAvg Amount.2]
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### WAvg(NULL), WAvg({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the member is a NULL entity.

**Query**

```
WAvg( {},1,1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
WAvg( NULL,1, )
```


 
</div>

                                                                         

### See Also


[Avg](Avg.md)

[Percentile](Percentile.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
