## VectorN

Returns a Vector of numerical values.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|value |numeric-expression |one-n | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
value
```



### Description

This function creates a vector object of numerical values (double). Different syntax might be used :

<pre>
- VectorN(1,2,3)
- VectorN([Measures].[Amount])
</pre>

Once the vector is created, you can call perform various operations on it :

<pre>
VectorN(1,2,3)->max(), VectorN(1,2,3)->min()...
</pre>

See [VectorN](VectorN.md) for examples of available operations and this [page](../mdx_types/vector.md) for all the available operations.



### Since Version

5.1.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(1.0,2.0,3.0) - numerical values

</div>

<div class="ic3-mdx-example-body" style="display:none">

Building a vector with a list of numerical values.

In our example a vector with three values {1.0,2.0,3.0}, integers are converted to floating point (double) values.

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1, 2.0, 3.0 ) -> sum()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>6.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 1.0 + 2.0 + 3.0
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - MDX expressions

</div>

<div class="ic3-mdx-example-body" style="display:none">

A vector can also be created with a list of MDX expressions.

In this example, we're creating a vector using an explicit list of numerical values using several notations : numeric literal, measure, tuple, ...

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1.0, [Measures].[Amount], ( [Geography].[Geo].[America], [Measures].[Amount] ) ) -> sum()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>1792.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 1.0 + [Measures].[Amount] + ( [Geography].[Geo].[America], [Measures].[Amount] )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - null/empty values

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL empty values are transformed to 0.0

In this example, the values 1,NULL,2 are converted to {1,0.0,2.0}

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,NULL,2 )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[1.0, 0.0, 2.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,0.0,2 )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,NULL,2, INCLUDEEMPTY )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - EXCLUDEEMPTY

</div>

<div class="ic3-mdx-example-body" style="display:none">

We can exclude empty values from a vector changing the value of the option.

In this example, the values 1,NULL,2 are converted to {1,,2.0}

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,NULL,2, EXCLUDEEMPTY ) -> mean()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>1.5</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS    (1.0+2.0) / 2.0
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - operator +

</div>

<div class="ic3-mdx-example-body" style="display:none">

VectorN class support the + operator.

In this example, (1,2,3) + 2 = (3,4,5)

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) + 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[3.0, 4.0, 5.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 2 + VectorN(1,2,3)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(3,4,5)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - operator -

</div>

<div class="ic3-mdx-example-body" style="display:none">

VectorN class support the - operator.

In this example, (1,2,3) - 2 = (-1,0,1)

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) - 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[-1.0, 0.0, 1.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS (-2) + VectorN(1,2,3)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(-1,0,1)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - operator * 

</div>

<div class="ic3-mdx-example-body" style="display:none">

VectorN class support the * operator.

In this example, (1,2,3) * 2 = (2,4,6)

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) * 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[2.0, 4.0, 6.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(2,4,6)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 2 * VectorN(1,2,3)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - operator / 

</div>

<div class="ic3-mdx-example-body" style="display:none">

VectorN class support the * operator.

In this example, (1,2,3) / 2 = (1/2,1,3/2)

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) / 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[0.5, 1.0, 1.5]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1/2,2/2,3/2)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - operator * (VectorN) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

VectorN class support the * operator on a VectorN

In this example, (1,2,3) * (3,2,1) = (1*3,2*2,3*1)

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1,2,3) * VectorN(3,2,1)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[3.0, 4.0, 3.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1*3,2*2,3*1)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) - operator ^ (VectorN) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

VectorN class support the ^ operator as the scalar or dot product.

In this example, (1,2,3) ^ (3,2,1) = 1*3 + 2*2 + 3*1

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1,2,3) ^ VectorN(3,2,1)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>10.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS (1*3 + 2*2 + 3*1.0)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) with NULL - operator +

</div>

<div class="ic3-mdx-example-body" style="display:none">

The + operator applied to a NULL or empty cell has no effect.

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) + NULL
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[1.0, 2.0, 3.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1,2,3)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) with NULL - operator -

</div>

<div class="ic3-mdx-example-body" style="display:none">

The - operator applied to a NULL or empty cell has no effect.

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) - NULL
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[1.0, 2.0, 3.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1,2,3)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) with NULL - operator * 

</div>

<div class="ic3-mdx-example-body" style="display:none">

The * operator applied to a NULL or empty cell returns a NULL/Empty cell.

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) * NULL
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS NULL
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS NULL * VectorN(1,2,3)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) with NULL - operator / 

</div>

<div class="ic3-mdx-example-body" style="display:none">

The / operator applied to a NULL or empty cell has the same effect as dividing by 0.0

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,2,3 ) / NULL
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[Infinity, Infinity, Infinity]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 1,1,1 ) / 0.0
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### VectorN(..) with NULL - operator ^ (VectorN) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

The ^ operator applied to a NULL or empty cell return a NULL/Empty cell

**Query**

```
WITH
    MEMBER [Measures].[val] AS VectorN(1,2,3) ^ (NULL)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS NULL
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS (NULL) ^ VectorN(3,2,1)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Vector](Vector.md)

[VectorA](VectorA.md)

[VectorK](VectorK.md)

[VectorS](VectorS.md)

[Matrix](Matrix.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
