## VectorK

Returns a Vector of numerical values, using member key value for the vector position.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|value |numeric-expression |one | |
|limit |numeric-expression |zero-one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
value
```



### Description

This function creates a vector object of numerical values (double) using the member key value to define the position in the vector (member key has to be an integer).

<pre>
- VectorK( [Geography].[Country].members, [Measures].[Amount])
</pre>

If for example,

<pre>
[Geography].[Country].[Switzerland] , key = 0, Amount =  20.0
[Geography].[Country].[Spain]       , key = 2, Amount = 120.0
[Geography].[Country].[France]      , key = 3, Amount = 200.0
</pre>

The vector :

<pre>
VectorK( {[Switzerland], [Spain], [France]} , [Amount] )
</pre>

will contain :

<pre>
( 20.0, 0.0, 120.0, 200.0 )
</pre>

Hint : ensure the keys values are compact and ideally start on 0.

Once the vector is created, you can call perform various operations on it :

<pre>
Vector(..)->max()
Vector(..)->min()
</pre>

See [VectorN](VectorN.md) for examples of available operations and this [page](../mdx_types/vector.md) for all the available operations.



### Since Version

6.0.3


                                                                      

### See Also


[SumOn](SumOn.md)

[Vector](Vector.md)

[VectorA](VectorA.md)

[VectorN](VectorN.md)

[VectorS](VectorS.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
