## VarTypeName

Returns the type of the argument


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |expression |one | |



### Return

```
string
```



### Description

Allows to retrieve the type of the MDX entity passed as parameter.

<pre>
    VarType   ( [Measures].[Amount] ) => "measure"
    ValueType ( [Measures].[Amount] ) => "double"
</pre>



### Since Version

6.5.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Basics

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the name of the type of the MDX entity passed as parameter.

**Query**

```
WITH
    MEMBER [dim] AS VarTypeName( [Measures] )
    MEMBER [mes] AS VarTypeName( [Measures].defaultMember )
SELECT
    { [dim], [mes] } ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">dim</td>
  <td class="ic3-mdx-result-cell-header">mes</td>
</tr>
<tr>
 <td>dimension</td>
 <td>measure</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [dim] AS "dimension"
    MEMBER [mes] AS "measure"
SELECT
    { [dim], [mes] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[ValTypeName](ValTypeName.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
