## Var

Returns the Variance, dividing by n


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the sample variance dividing by n ([Wikipedia](https://en.wikipedia.org/wiki/Variance)).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Var

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the sample variance. Note that empty members are ignored.

**Query**

```
Ceiling(Var( [Geography].[Geo].[Country].members, [Amount] ),4)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>129908.0</td></tr></table>


**Assertion : MDX Equals**

```
Ceiling(Var( nonempty([Geography].[Geo].[Country],[Amount]), [Amount] ),4)
```


**Assertion : MDX Equals**

```
Ceiling( Stdev([Geography].[Geo].[Country],[Amount]) * Stdev([Geography].[Geo].[Country],[Amount]), 4)
```


 
</div>

                                                                                                            

### See Also


[Stdev](Stdev.md)

[StdevP](StdevP.md)

[Stddev](Stddev.md)

[StddevP](StddevP.md)

[VarP](VarP.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
