## ValTypeName

Returns the type of the argument when evaluated.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |expression |one | |



### Return

```
string
```



### Description

Allows to retrieve the type of the MDX entity passed as parameter when evaluated. For example, if the argument is a measures member then this function will return the type of the measure when evaluated.

<pre>
VarType   ( [Measures].[Amount] ) => "measure"
ValueType ( [Measures].[Amount] ) => "double"
</pre>



### Since Version

6.5.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Measure's Type

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the name of the type of the measure when evaluated. Notice the difference with VarTypeName that returns "measure".

**Query**

```
WITH
    MEMBER [mesV] AS ValTypeName( [Measures].defaultMember )
    MEMBER [mesT] AS VarTypeName( [Measures].defaultMember )
SELECT
    { [mesV], [mesT] } ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">mesV</td>
  <td class="ic3-mdx-result-cell-header">mesT</td>
</tr>
<tr>
 <td>numeric</td>
 <td>measure</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [mesV] AS "numeric"
    MEMBER [mesT] AS "measure"
SELECT
    { [mesV], [mesT] } ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[VarTypeName](VarTypeName.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
