## UpperCrossjoin

Returns the upper cross product of the specified sets.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |set-expression |zero-one | |



### Return

```
set
```



### Description

Returns a list of tuples as a result of the upper cross product of the specified sets.

UpperCrossjoin(A,B) = { (Ai,Bj) }, for all i,j where j > i

and

UpperCrossjoin(A) = { (Ai,Aj) }, for all i,j where j > i

Same hierarchy on both tuple set is allowed. No autoexist is performed on the tuples.

If you see A and B as a matrix with in the cells tuples, it will return the upper triangle of the matrix
without the diagonal. It is an easy function to get all combinations



### Since Version

5.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UpperCrossjoin(set,set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates a upper cross product.

**Query**

```
UpperCrossjoin( {[Geography].[Geo].[America],[Geography].[Geo].[Europe],[Geography].[Geo].[Country].[Canada]} , {[Time].[Calendar].[Year].[2010],[Time].[Calendar].[Year].[2011]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2011] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ ([Geography].[Geo].[America],[Time].[Calendar].[Year].[2011]) }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UpperCrossjoin(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates a upper cross product using twice the same set. Note that an autoexist is performed on the
set declaration, that is not the case for the UpperCrossjoin.

**Query**

```
UpperCrossjoin( {[Geography].[Geo].[All Regions],[Geography].[Geo].[America],[Geography].[Geo].[Country].[Canada]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Geography].[Geo].[Continent].[America] ), 
  ( [Geography].[Geo].[All Regions], [Geography].[Geo].[Country].[Canada] ), 
  ( [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Country].[Canada] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ ([Geography].[Geo].[All Regions],[Geography].[Geo].[America]), ([Geography].[Geo].[All Regions],[Geography].[Geo].[Canada]), ([Geography].[Geo].[America],[Geography].[Geo].[Canada]) }
```


 
</div>

                                                                                                            

### See Also


[Crossjoin](Crossjoin.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
