## UniqueName

Returns the unique name of a specified dimension, hierarchy, level, or member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |expression |one | |



### Return

```
string
```



### Description

Returns the unique name of a specified dimension, hierarchy, level, or member. Unique names are server side dependant and the client side cannot assume any specific content.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UniqueName( member )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the unique name of the country [Spain]; this is equivalent as requesting the 'MEMBER_UNIQUE_NAME' property.

**Query**

```
WITH
    MEMBER [Spain Unique Name] AS [Geography].[Geo].[Spain].uniqueName
SELECT
    [Spain Unique Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain Unique Name</td>
</tr>
<tr>
 <td>[Geography].[Geo].[Country].&[ES]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Spain Unique Name] AS [Geography].[Geo].[Spain].Properties( 'MEMBER_UNIQUE_NAME' )
SELECT
    [Spain Unique Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UniqueName( level )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the unique name of the country level.

**Query**

```
WITH
    MEMBER [Country Unique Name] AS [Geography].[Geo].[Country].uniqueName
SELECT
    [Country Unique Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Country Unique Name</td>
</tr>
<tr>
 <td>[Geography].[Geo].[Country]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Country Unique Name] AS "[Geography].[Geo].[Country]"
SELECT
    [Country Unique Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UniqueName( hierarchy )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the unique name of the [Geography].[Geo] hierarchy.

**Query**

```
WITH
    MEMBER [Geo Unique Name] AS [Geography].[Geo].uniqueName
SELECT
    [Geo Unique Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Geo Unique Name</td>
</tr>
<tr>
 <td>[Geography].[Geo]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geo Unique Name] AS "[Geography].[Geo]"
SELECT
    [Geo Unique Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### UniqueName( dimension )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the unique name of the [Geography] dimension.

**Query**

```
WITH
    MEMBER [Geography Unique Name] AS [Geography].uniqueName
SELECT
    [Geography Unique Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Geography Unique Name</td>
</tr>
<tr>
 <td>[Geography]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography Unique Name] AS "[Geography]"
SELECT
    [Geography Unique Name] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Name](Name.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
