## TopCount

Returns the highest specified count of tuples. The numeric expression is used to evaluate the tuple values.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|count |numeric-expression |one | |
|measure |value-expression |zero-one | |
|flag |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
set
```



### Description

Returns the highest specified count of tuples.

1) A measures expression is specified.

The tuples of the specified set are sorted in descending order according to their cell values. Then, the specified number of tuples with the highest values are returned. Note that empty cells are not ignored and are considered as zero values.

2) A measures expression is not specified.

The TopCount(set,count,measure) function is then equivalent to the Head(Order(set,measure,BDESC),count) function.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(set,count,scalar) - set of members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the highest 'count' members of the set. Members are evaluated using the 'scalar' expression.

Our example returns the 5 [Cities] with the highest [Amount].

**Query**

```
TopCount([Geography].[Geo].[City].Members, 5, [Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[Geneva], 
  [Geography].[Geo].[City].[Zurich], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
Head(ORDER([Geography].[Geo].[City].Members,[Measures].[Amount], BDESC), 5)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(set,count,string) - set of members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Similar example as above but using a string as value to compare.

Our example returns the 5 [Cities] sorted by name.

**Query**

```
TopCount([Geography].[Geo].[City].Members, 5, [Geography].[Geo].currentmember.caption)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Zurich], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Quebec]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
Head(ORDER([Geography].[Geo].[City].Members,[Geography].[Geo].currentmember.caption, BDESC), 5)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(member-set,numeric) same as Head(member-set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Without any numeric expression specified, the TopCount function is equivalent to the Head function.

**Query**

```
TopCount([Geography].[Geo].[Country].Members, 3)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
Head([Geography].[Geo].[Country].Members, 3)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(member-set,numeric,measure, EXCLUDEEMPTY) - exclude empty cells

</div>

<div class="ic3-mdx-example-body" style="display:none">

Tuples/Members with empty cells can be excluded in TopCount with the EXCLUDEEMPTY flag.

**Query**

```
SELECT
    TopCount( [Geography].[Geo].[Country].Members, 3, [Measures].[Amount], EXCLUDEEMPTY ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
  <td class="ic3-mdx-result-cell-header">France</td>
</tr>
<tr>
 <td>768</td>
 <td>248</td>
 <td>4</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
   Head( Order( Filter( [Geography].[Geo].[Country].Members, IsEmpty( [Measures].[Amount] ) = FALSE ),[Measures].[Amount], DESC), 3)  ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(member-set,numeric,measure) - empty cells

</div>

<div class="ic3-mdx-example-body" style="display:none">

Tuples/Members with empty cells are included in TopCount, they are considered as zero values.

**Query**

```
WITH
    SET    [Empty Countries] AS Filter( [Geography].[Geo].[Country].Members, IsEmpty( [Measures].[Amount] ))
    MEMBER [Top Count]       AS Count( TopCount( [Empty Countries], 1, [Measures].[Amount] ))

SELECT
    [Top Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Top Count</td>
</tr>
<tr>
 <td>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Top Count] AS 1
SELECT
    [Top Count] ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(set,count,numeric) - set of tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the highest 'count' tuples of the set. Tuples are evaluated using the 'numeric' expression.

Our example returns the 3 [Countries] for [2010] with the lowest [Amount].

**Query**

```
TopCount( NonEmpty( [Time].[Calendar].[2010] * [Geography].[Geo].[Country].Members ), 3, [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[United States] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[Switzerland] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[France] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head( Order( NonEmpty( [Time].[Calendar].[2010] * [Geography].[Geo].[Country].Members ), [Measures].[Amount], BDESC), 3)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(set,count,numeric) - set of duplicated members

</div>

<div class="ic3-mdx-example-body" style="display:none">

TopCount makes no difference with duplicated members. Our example is selecting twice the top city for [Measures].[Amount].

**Query**

```
TopCount( Union( [Geography].[Geo].[City].Members, [Geography].[Geo].[City].Members, ALL), 2, [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[New York]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{
TopCount( [Geography].[Geo].[City].Members, 1, [Measures].[Amount] ),
TopCount( [Geography].[Geo].[City].Members, 1, [Measures].[Amount] )
}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount(NULL,numeric), TopCount({},numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applying the function to NULL produces the same result as for the empty set.

**Query**

```
TopCount(NULL, 2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
TopCount({},2)
```


 
</div>

                                                                         

### See Also


[BottomCount](BottomCount.md)

[TopPercent](TopPercent.md)

[TopSum](TopSum.md)

[Head](Head.md)

[DrilldownMemberTop](DrilldownMemberTop.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
