## Sum

Returns the sum value of the specified set expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |value-expression |zero-one | |



### Return

```
value
```



### Description

Returns the sum value of the specified set, evaluated using 'value-expression'.

If no numeric expression is specified, the current members context will be used to evaluate the tuples.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Sum(tuple-set, Numeric_Expression)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the sum of the tuples set evaluating the numeric expression.

In our example, for each member of the set we add 2.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Sum( {[Geography].[Geo].[America],[Geography].[Geo].[America]}, 2.0 )
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td>4.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS 4.0
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Sum(tuple-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Without a numeric-expression, returns the sum of the tuples evaluated using the current context.

In our example, [Measures].[Amount]

**Query**

```
WITH
    MEMBER [Geo].[Sum] AS Sum( {[Geography].[Geo].[America],[Geography].[Geo].[America]} )
SELECT
    [Geo].[Sum] ON 0
FROM
    [Sales]
 WHERE ([Measures].[Amount])
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum</td>
</tr>
<tr>
 <td>1536</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geo].[Sum] AS Sum( {[Geography].[Geo].[America],[Geography].[Geo].[America]},[Measures].[Amount] )
SELECT
    [Geo].[Sum] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Sum(NULL),Sum({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity or an empty set.

**Query**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Sum(NULL)
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Sum Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS Sum({})
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Sum Amount] AS null
SELECT
    [Measures].[Sum Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Avg](Avg.md)

[Min](Min.md)

[Max](Max.md)

[Median](Median.md)

[Percentile](Percentile.md)

[Vector](Vector.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
