## Subset

Returns subset of the original set in the specified range of elements.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression | | |
|start-index |numeric-expression |one | |
|count |numeric-expression |zero-one |infinite |



### Return

```
set
```



### Description

Returns a set containing 'count' number of the elements beginning at start-index (first member is 0)

If the count parameter is not specified the subset starting from a specified index and going to the end of the specified set is returned.

If the count parameter is lower or equals to 0, an empty set will be returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(member-set,start,count)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns count items of the set starting at start.

In our example, return the the 2d and 3d member.

**Query**

```
Subset([Geography].[Geo].[Country].Members,1,2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Country].Members(1),[Geography].[Geo].[Country].Members(2)}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(member-set,start) - no count

</div>

<div class="ic3-mdx-example-body" style="display:none">

If no count is specified, all items from 'start' to the end of the set will be returned.

In our example, return the whole list as we are starting at 0.

**Query**

```
Subset([Geography].[Geo].[Continent].Members,0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Continent].Members}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(member-set,start,count) - specified elements count > than size of the set

</div>

<div class="ic3-mdx-example-body" style="display:none">

The subset will not return more than the available set of items.

In our example, we will return all [Continent] members except the first one. Actually only one item.

**Query**

```
Subset([Geography].[Geo].[Continent].Members,1,300000000)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Except([Geography].[Geo].[Continent].Members,[Geography].[Geo].[Continent].Members(0))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(member-set,start,count) - negative count

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if the specified count is negative

**Query**

```
Subset([Geography].[Geo].[Continent].Members,1,-2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset({},numeric),Subset(NULL,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity or an empty set.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Subset( [Geography].[Geo].[Continent].Members, 1, 0 )
```


**Assertion : MDX Equals**

```
Subset( [Geography].[Geo].[Continent].Members, 123456, 1)
```


**Assertion : MDX Equals**

```
Subset( [Geography].[Geo].[Continent].Members, -1)
```


**Assertion : MDX Equals**

```
Subset( {}, 1)
```


**Assertion : MDX Equals**

```
Subset( NULL, 1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(member-set,numeric,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
Subset([Geography].[Geo].[Continent].Members,1, "hello")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Subset() : argument (2) type mismatch: expected:'numeric', got:'string'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(member-set, string)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
Subset([Geography].[Geo].[Continent].Members, "hello")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Subset() : argument (1) type mismatch: expected:'numeric', got:'string'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subset(string,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
Subset("hello",2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Subset() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Head](Head.md)

[Tail](Tail.md)

[Range](Range.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
