## SubCubeUnion

Filters the facts performing a union operation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one-n | |



### Return

```
void
```



### Description

The SubCube functions allows for filtering facts using different operations. They can be used in the Eval() function, in the FILTERBY clause and to create categories.

SubCubeUnion selects all facts defined by all the parameters. For example SubCubeUnion(A,B), or SubCubeUnion( {A,B} ), will define a subCube with only the rows defined by tuples A and B.

This is similar to the set behaviour in a where clause.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeUnion()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Creates a subCube using the union operator.

In our example, we select [France] and [Spain]. This behaves like a set in the where clause or subselect.

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[France+Spain] AS SubCubeUnion( [Geography].[Geo].[France],[Geography].[Geo].[Spain]  )
SELECT
 [Stats].[Ex].[All-M].[France+Spain] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">France+Spain</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[France+Spain] AS ([Measures].[Amount],[Geography].[Geo].[Spain]) +  ([Measures].[Amount],[Geography].[Geo].[France])
SELECT
 [Measures].[France+Spain] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
SELECT
 [Measures].[Amount] on 0
FROM [Sales]
WHERE {[Geography].[Geo].[Spain],[Geography].[Geo].[France]}
```


**Assertion : Cell Equals**

```
SELECT
 [Measures].[Amount] on 0
FROM  ( SELECT {[Geography].[Geo].[Spain],[Geography].[Geo].[France]} on 0 FROM [Sales])
```


 
</div>

                                                                                                            

### See Also


[SubCubeComplement](SubCubeComplement.md)

[SubCubeIntersect](SubCubeIntersect.md)

[SubCubeMinus](SubCubeMinus.md)

[SubCubeOthers](SubCubeOthers.md)

[SubCubeSymDifference](SubCubeSymDifference.md)

[FilterBy](FilterBy.md)

[Create (Category)](Create%20(Category).md)

[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
