## SubCubeSymDifference

Filters the facts performing an symmetrical difference operation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one-n | |



### Return

```
void
```



### Description

The SubCube functions allows for filtering facts using different operations. They can be used in the Eval() function, in the FILTERBY clause and to create categories.

SubCubeSymDifference selects all facts defined in the first and the second parameter that are not in both ([Wikipedia](http://en.wikipedia.org/wiki/Symmetric_difference)). For example SubCubeSymDifference(A,B) will define a subCube with the rows defined in A and B but that are not in both A and B.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeSymDifference()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Creates a subCube using the symmetric-difference operator.

In our example, we select [France] and [Jan 2011] except ([Geography].[Geo].[France], [Time].[Jan 2011]).

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[SymDiff - France & Jan 2011] AS SubCubeSymDifference([Geography].[Geo].[France], [Time].[Jan 2011] )
SELECT
[Stats].[Ex].[All-M].[SymDiff - France & Jan 2011] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">SymDiff - France & Jan 2011</td>
</tr>
<tr>
 <td>4</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[SymDiff - France & Jan 2011] AS ([Geography].[Geo].[France],[Measures].[Amount]) + ([Time].[Jan 2011],[Measures].[Amount]) - ([Time].[Jan 2011],[Measures].[Amount] )
SELECT
 [Measures].[SymDiff - France & Jan 2011] on 0
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[SubCubeComplement](SubCubeComplement.md)

[SubCubeIntersect](SubCubeIntersect.md)

[SubCubeMinus](SubCubeMinus.md)

[SubCubeOthers](SubCubeOthers.md)

[SubCubeUnion](SubCubeUnion.md)

[FilterBy](FilterBy.md)

[Create (Category)](Create%20(Category).md)

[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
