## SubCubeOthers

Creates an 'Others' category member


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |zero-n | |



### Return

```
void
```



### Description

The SubCube functions allows for filtering facts using different operations. They can be used in the Eval() function, in the FILTERBY clause and to create categories.

SubCubeOthers() without parameters allows for creating a category member based on the siblings that are not "others". It is equivalent of the selection of the parent minus the union of the siblings:

<pre>
SubCubeMinus( parentMember, SubCubeUnion( {siblings} ) )
</pre>

If the parent member is the all member, it is equivalent to:

<pre>
SubCubeComplement( SubCubeUnion( {siblings} ) )
</pre>

E.g. assuming the following hierarchy:

<pre>
Countries
  United States
  Switzerland
  Others as SubCubeOthers()
</pre>

The "Others" will be [Countries] - [United States] - [Switzerland]

With a parameter it is a shortcut of:

<pre>
SubCubeMinus( parentMember, SubCubeUnion( {parameter tuples} ) )
</pre>



### Since Version

5.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeOthers()

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubCubeOthers() without parameters takes all siblings excluding members that are 'Others'.

In this example, it is a shortcut for SubCubeComplement( SubCubeUnion(France,Spain) ).

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Others] AS SubCubeOthers()
  CATEGORY MEMBER [Stats].[Ex].[All-M].[France] AS [Geography].[Geo].[France]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Spain] AS [Geography].[Geo].[Spain]
SELECT
 [Stats].[Ex].members on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All-M</td>
  <td class="ic3-mdx-result-cell-header">Others</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
</tr>
<tr>
 <td>1023</td>
 <td>1016</td>
 <td>4</td>
 <td>3</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Others] AS SubCubeComplement( SubCubeUnion([Geography].[Geo].[France],[Geography].[Geo].[Spain]) )
  CATEGORY MEMBER [Stats].[Ex].[All-M].[France] AS [Geography].[Geo].[France]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Spain] AS [Geography].[Geo].[Spain]
SELECT
 [Stats].[Ex].members on 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeOthers() - parent

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example we're going to build a more complex hierarchy.

For other categories not attached

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Europe] AS [Geography].[Geo].[Europe]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Spain] AS [Geography].[Geo].[Spain]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Switzerland] AS [Geography].[Geo].[Switzerland]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Others] AS SubCubeOthers()
  CATEGORY MEMBER [Stats].[Ex].[All-M].[America] AS [Geography].[Geo].[America]
  CATEGORY MEMBER [Stats].[Ex].[America].[US] AS [Geography].[Geo].[United States]
  CATEGORY MEMBER [Stats].[Ex].[America].[Others] AS SubCubeOthers()
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Others Continent] AS SubCubeOthers()
SELECT
 [Measures].[Amount] on 0,
 [Stats].[Ex].members on 1
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All-M</td>
 <td>1023</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Others</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;US</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Others</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Others Continent</td>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Europe] AS [Geography].[Geo].[Europe]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Spain] AS [Geography].[Geo].[Spain]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Switzerland] AS [Geography].[Geo].[Switzerland]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Others] AS SubCubeMinus([Geography].[Geo].[Europe], SubCubeUnion([Geography].[Geo].[Spain],[Geography].[Geo].[Switzerland]) )
  CATEGORY MEMBER [Stats].[Ex].[All-M].[America] AS [Geography].[Geo].[America]
  CATEGORY MEMBER [Stats].[Ex].[America].[US] AS [Geography].[Geo].[United States]
  CATEGORY MEMBER [Stats].[Ex].[America].[Others] AS SubCubeMinus( [Geography].[Geo].[America],[Geography].[Geo].[United States])
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Others Continent] AS SubCubeComplement( {[Geography].[Geo].[Europe],[Geography].[Geo].[America]} )
SELECT
 [Measures].[Amount] on 0,
 [Stats].[Ex].members on 1
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeOthers(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubCubeOthers() with a list of parameters behaves as SubCubeComplement().

In our example, we select all except [France].

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeOthers([Geography].[Geo].[France] )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All but France</td>
</tr>
<tr>
 <td>1019</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[[All but France] AS ([Measures].[Amount],[Geography].[Geo].[All])-  ([Measures].[Amount],[Geography].[Geo].[France])
SELECT
 [Measures].[[All but France] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeComplement( [Geography].[Geo].[France] )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeOthers(member) - parent

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubCubeOthers() with a list of parameters behaves as SubCubeComplement().

In our example, we select all except [France].

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[Europe] AS [Geography].[Geo].[Europe]
  CATEGORY MEMBER [Stats].[Ex].[Europe].[Europe but France] AS SubCubeOthers([Geography].[Geo].[France])
SELECT
 [Stats].[Ex].[Europe].[Europe but France] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Europe but France</td>
</tr>
<tr>
 <td>251</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[[Europe but France] AS ([Measures].[Amount],[Geography].[Geo].[Europe])-  ([Measures].[Amount],[Geography].[Geo].[France])
SELECT
 [Measures].[[Europe but France] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeMinus([Geography].[Geo].[Europe], [Geography].[Geo].[France] )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeOthers(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

SubCubeOthers() with a list of parameters behaves as SubCubeComplement().

In our example, we select all except [France] and [Spain].

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France/Spain] AS SubCubeOthers( [Geography].[Geo].[France], [Geography].[Geo].[Spain] )
SELECT
 [Stats].[Ex].[All-M].[All but France/Spain] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All but France/Spain</td>
</tr>
<tr>
 <td>1016</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeOthers( {[Geography].[Geo].[France], [Geography].[Geo].[Spain]} )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[[All but France/Spain] AS ([Measures].[Amount],[Geography].[Geo].[All])-  ([Measures].[Amount],[Geography].[Geo].[France]) -  ([Measures].[Amount],[Geography].[Geo].[Spain])
SELECT
 [Measures].[[All but France/Spain] on 0
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[SubCubeComplement](SubCubeComplement.md)

[SubCubeIntersect](SubCubeIntersect.md)

[SubCubeMinus](SubCubeMinus.md)

[SubCubeSymDifference](SubCubeSymDifference.md)

[SubCubeUnion](SubCubeUnion.md)

[FilterBy](FilterBy.md)

[Create (Category)](Create%20(Category).md)

[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
