## SubCubeMinus

Filters the facts performing a minus operation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |set-expression |one | |



### Return

```
void
```



### Description

The SubCube functions allows for filtering facts using different operations. They can be used in the Eval() function, in the FILTERBY clause and to create categories.

SubCubeMinus selects all facts defined by the first parameter minus the second one. For example SubCubeMinus(A,B) will define a subCube with only the rows defined in A that are not defined in B, also A - B.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeMinus()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Creates a subCube using the minus operator.

In our example, we select all except [France].

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeMinus([Geography].[Geo].[All], [Geography].[Geo].[France] )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">All but France</td>
</tr>
<tr>
 <td>1019</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[[All but France] AS ([Measures].[Amount],[Geography].[Geo].[All])-  ([Measures].[Amount],[Geography].[Geo].[France])
SELECT
 [Measures].[[All but France] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[All but France] AS SubCubeComplement( [Geography].[Geo].[France] )
SELECT
 [Stats].[Ex].[All-M].[All but France] on 0
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[SubCubeComplement](SubCubeComplement.md)

[SubCubeIntersect](SubCubeIntersect.md)

[SubCubeOthers](SubCubeOthers.md)

[SubCubeSymDifference](SubCubeSymDifference.md)

[SubCubeUnion](SubCubeUnion.md)

[FilterBy](FilterBy.md)

[Create (Category)](Create%20(Category).md)

[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
