## SubCubeIntersect

Filters the facts performing an intersect operation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one-n | |



### Return

```
void
```



### Description

The SubCube functions allows for filtering facts using different operations. They can be used in the Eval() function, in the FILTERBY clause and to create categories.

SubCubeIntersect selects all facts defined by all the parameters. For example SubCubeIntersect(A,B), or SubCubeIntersect( {A,B} ), will define a subCube with only the rows defined by _ both _ tuples A and B.

This is similar to the set behaviour as defining A and B on two axis of a SubSelect.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SubCubeIntersect()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Creates a subCube using the intersect operator.

For the example we're going to use different hierarchies as intersect makes sense on the same hierarchy only if a many-to-many relation exists (same facts associated several sibling members).

**Query**

```
WITH
  CATEGORY HIERARCHY [Stats].[Ex]
  CATEGORY MEMBER [Stats].[Ex].[All-M].[France Jan 2011] AS SubCubeIntersect( [Geography].[Geo].[France], [Time].[Jan 2011]  )
SELECT
 [Stats].[Ex].[All-M].[France Jan 2011] on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">France Jan 2011</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[France Jan 2011] AS ([Measures].[Amount],[Geography].[Geo].[France], [Time].[Jan 2011])
SELECT
 [Measures].[France Jan 2011] on 0
FROM [Sales]
```


**Assertion : Cell Equals**

```
SELECT
 [Measures].[Amount] on 0
FROM [Sales]
WHERE ([Geography].[Geo].[France], [Time].[Jan 2011])
```


**Assertion : Cell Equals**

```
SELECT
 [Measures].[Amount] on 0
FROM ( SELECT ([Geography].[Geo].[France], [Time].[Jan 2011]) on 0 from [Sales])
```


**Assertion : Cell Equals**

```
SELECT
 [Measures].[Amount] on 0
FROM ( SELECT [Geography].[Geo].[France] on 0, [Time].[Jan 2011] on 1 from [Sales])
```


 
</div>

                                                                                                            

### See Also


[SubCubeComplement](SubCubeComplement.md)

[SubCubeMinus](SubCubeMinus.md)

[SubCubeOthers](SubCubeOthers.md)

[SubCubeSymDifference](SubCubeSymDifference.md)

[SubCubeUnion](SubCubeUnion.md)

[FilterBy](FilterBy.md)

[Create (Category)](Create%20(Category).md)

[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
