## StrToValue

Converts a string to its value representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |
| |CONSTRAINED |zero-one | |



### Return

```
value
```



### Description

Converts a string to its numeric value (e.g. 2.2)

- without the CONSTRAINED flag, the string can contain any valid MDX expression that can be converted into a numeric.

- with the CONSTRAINED flag, only string containing directly a numeric expression can used (e.g. '2.2').



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToValue(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a numeric value evaluating the string expression.

In our example, we return 2.2

**Query**

```
WITH
    MEMBER [Measures].[V] AS StrToValue("2.2")
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>2.2</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS 2.2
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToValue(string) - MDX expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

The parameter string can be any valid expression containing MDX functions.

In our example, we use a string involving member evaluation and some basic mathematical functions

**Query**

```
WITH
    MEMBER [Measures].[V] AS StrToValue( [Time].[Calendar].[2010].Name + "+" + [Time].[Calendar].[2011].Name)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>4021</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS 4021
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToValue(string, CONSTRAINED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the CONSTRAINED flag is present, the string has to match a numeric value, no evaluation is performed.

**Query**

```
WITH
    MEMBER [Measures].[V] AS StrToValue("2.2", CONSTRAINED)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>2.2</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[V] AS 2.2
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToValue(string, CONSTRAINED) - failing

</div>

<div class="ic3-mdx-example-body" style="display:none">

With the CONSTRAINED flag, only scalar values are being converted (no expression/function is allowed).

**Query**

```
WITH
    MEMBER [Measures].[ERROR] AS StrToValue("1+1", CONSTRAINED)
SELECT
    [Measures].[ERROR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">ERROR</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_CONSTRAINED_VIOLATED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_CONSTRAINED_VIOLATED](icCubeError.md#olap_constrained_violated)<br>Error Message : StrToValue() : the restrictions imposed by the CONSTRAINED flag were violated.</pre>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToValue(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[XXX] AS StrToValue(NULL)
SELECT
    [Measures].[XXX] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XXX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_MDX_EXPRESSION_EXPECTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_MDX_EXPRESSION_EXPECTED](icCubeError.md#olap_mdx_expression_expected)<br>Error Message : StrToValue() : expression expected : received a null/empty string expression.</pre>


 
</div>

                                                                         

### See Also


[StrToLevel](StrToLevel.md)

[StrToMember](StrToMember.md)

[StrToSet](StrToSet.md)

[StrToTuple](StrToTuple.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
