## StrToTuple

Converts a string to its tuple representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |
| |CONSTRAINED |zero-one | |



### Return

```
tuple
```



### Description

Converts a string to its tuple representation.

- without the CONSTRAINED flag, the string can contain any valid MDX expression that can be converted into a MDX tuple.

- with the CONSTRAINED flag, only tuples build with MDX member's name can be used. This allows to avoid code injection into the server.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToTuple(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a tuple after evaluating the string expression.

In our example, we convert "([Geography].[Geo].[Paris],[Time].[Calendar].[2010])" to a tuple.

**Query**

```
StrToTuple('([Geography].[Geo].[Paris],[Time].[Calendar].[2010])')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[City].[Paris], [Time].[Calendar].[Year].[2010] )
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
([Geography].[Geo].[Paris],[Time].[Calendar].[2010])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToTuple(string) - MDX expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

The parameter string can be any valid expression containing MDX functions.

In our example, we convert "Root([Geography].[Geo])" to a tuple.

**Query**

```
StrToTuple('Root([Geography].[Geo])')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Geography].[Economy].[ALL], [Geography].[Letter].[All Letters] )
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
Root([Geography].[Geo])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToTuple(string,CONSTRAINED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the CONSTRAINED flag is present, the member names have to match existing member's names; no evaluation is performed.

**Query**

```
StrToTuple('([Geography].[Geo].[Paris],[Time].[Calendar].[2010])',CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[City].[Paris], [Time].[Calendar].[Year].[2010] )
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
([Geography].[Geo].[Paris],[Time].[Calendar].[2010])
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToTuple(string,CONSTRAINED) - failing

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using functions is not authorized with the CONSTRAINED flag.

**Query**

```
StrToTuple('Root([Geography].[Geo])',CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_CONSTRAINED_VIOLATED](icCubeError.md#olap_constrained_violated)</td></tr><tr><td>Error Message</td><td>

StrToTuple() : the restrictions imposed by the CONSTRAINED flag were violated.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToTuple(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
StrToTuple(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_MDX_EXPRESSION_EXPECTED](icCubeError.md#olap_mdx_expression_expected)</td></tr><tr><td>Error Message</td><td>

StrToTuple() : expression expected : received a null/empty string expression.</td></tr></table>


 
</div>

                                                                         

### See Also


[StrToMember](StrToMember.md)

[StrToLevel](StrToLevel.md)

[StrToSet](StrToSet.md)

[StrToValue](StrToValue.md)

[TupleToStr](TupleToStr.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
