## StrToSet

Converts a string to a set representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |
| |CONSTRAINED |zero-one | |



### Return

```
set
```



### Description

Converts string to his set representation.

- without the CONSTRAINED flag, the string can contain any valid MDX expression that can be converted into a MDX set.

- with the CONSTRAINED flag, only set build with MDX member's name can be used. This allows to avoid code injection into the server.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToSet(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set after evaluating the string expression.

In this example we convert "{[Geography].[Geo].[Paris],[Geography].[Geo].[Madrid]}" string to a set.

**Query**

```
StrToSet('{[Geography].[Geo].[Paris],[Geography].[Geo].[Madrid]}')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Madrid]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{[Geography].[Geo].[Paris],[Geography].[Geo].[Madrid]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToSet(string) - MDX expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

The parameter string can be any valid expression containing MDX functions.

In this example we convert "{[Geography].[Geo].[United States].children}" string to a set.

**Query**

```
StrToSet('[Geography].[Geo].[United States].Children')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[United States].Children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToSet(string,CONSTRAINED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the CONSTRAINED flag is present, the member names have to match existing member's names; no evaluation is performed.

**Query**

```
StrToSet ('{[Geography].[Geo].[Paris],[Geography].[Geo].[Madrid]}',CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Madrid]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{[Geography].[Geo].[Paris],[Geography].[Geo].[Madrid]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToSet(string,CONSTRAINED) - failing

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using functions is not authorized with the CONSTRAINED flag.

**Query**

```
StrToSet ('[Geography].[Geo].[Continent].Members',CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_CONSTRAINED_VIOLATED](icCubeError.md#olap_constrained_violated)</td></tr><tr><td>Error Message</td><td>

StrToSet() : the restrictions imposed by the CONSTRAINED flag were violated.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToSet(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[V] AS StrToSet(NULL)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_MDX_EXPRESSION_EXPECTED)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_MDX_EXPRESSION_EXPECTED](icCubeError.md#olap_mdx_expression_expected)<br>Error Message : StrToSet() : expression expected : received a null/empty string expression.</pre>


 
</div>

                                                                         

### See Also


[SetToStr](SetToStr.md)

[StrToLevel](StrToLevel.md)

[StrToMember](StrToMember.md)

[StrToTuple](StrToTuple.md)

[StrToValue](StrToValue.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
