## StrToLevel

Converts a string to a level representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-expression |one | |
| |CONSTRAINED |zero-one | |



### Return

```
level
```



### Description

Converts a string to its level representation.

- without the CONSTRAINED flag, the string can contain any valid MDX expression that can be converted into a MDX level.

- with the CONSTRAINED flag, only MDX level's name can be used. This allows to avoid code injection into the server.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToLevel(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a level after evaluating the string expression.

In our example, we converts "[Geography].[Geo].[City]" to a level.

**Query**

```
StrToLevel('[Geography].[Geo].[City]')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Caracas], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[City].[Geneva], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[City]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToLevel(string,CONSTRAINED)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the CONSTRAINED flag is present, the string has to match an existing level's name; no MDX evaluation is performed.

**Query**

```
StrToLevel( '[Geography].[Geo].[Continent]', CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].[Continent]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StrToLevel(string,CONSTRAINED) - failing

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using functions is not authorized with the CONSTRAINED flag.

**Query**

```
StrToLevel( '[Geography].[Geo].Levels(0)', CONSTRAINED)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_CONSTRAINED_VIOLATED](icCubeError.md#olap_constrained_violated)</td></tr><tr><td>Error Message</td><td>

StrToLevel() : the restrictions imposed by the CONSTRAINED flag were violated.</td></tr></table>


 
</div>

                                                                         

### See Also


[StrToMember](StrToMember.md)

[StrToSet](StrToSet.md)

[StrToTuple](StrToTuple.md)

[StrToValue](StrToValue.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
