## StdevP

Returns the standard deviation, dividing by n


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the standard deviation dividing by n ([Wikipedia](https://en.wikipedia.org/wiki/Standard_deviation)).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StdevP

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the standard deviation. Note that empty members are ignored.

**Query**

```
StdevP( [Geography].[Geo].[Country].members, [Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>312.13809043434605</td></tr></table>


**Assertion : MDX Equals**

```
StddevP( [Geography].[Geo].[Country],[Amount] )
```


**Assertion : MDX Equals**

```
StdevP( nonempty([Geography].[Geo].[Country],[Amount]), [Amount] )
```


 
</div>

                                                                                                            

### See Also


[Stdev](Stdev.md)

[Stddev](Stddev.md)

[StddevP](StddevP.md)

[Var](Var.md)

[VarP](VarP.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
