## Sets

Create a set of members / tuples.




### Description

Similarly to calculated members the following statement allows for creating sets :

`WITH [ DYNAMIC | STATIC ] SET name AS MDX-expression`

`DYNAMIC` (the default modifier) `SETs` are evaluated using the context of evaluation in the query (e.g., slicer).

`STATIC SETs` are evaluated without taking into account the context of evaluation in the query (e.g., slicer).
This allows to create a set that behaves like a schema static set within an MDX statement/query.

Note that using the `DYNAMIC|STATIC` modifiers is specific to icCube.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DYNAMIC (Default) Evaluation

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example is creating the top 3 countries of [2010] (slicer) according to the measure [Amount].

**Query**

```
WITH SET [my-top-2010-countries] AS TopCount( [Geography].[Geo].[Country].members, 3, [Measures].[Amount] )

SELECT [my-top-2010-countries] ON 0

FROM [sales]
WHERE [2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
  <td class="ic3-mdx-result-cell-header">France</td>
</tr>
<tr>
 <td>768</td>
 <td>248</td>
 <td>4</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT TopCount( [Geography].[Geo].[Country].members, 3, ([2010], [Measures].[Amount] ) ) ON 0
FROM [sales]
```


**Assertion : Cell Equals**

```
WITH DYNAMIC SET [my-top-2010-countries] AS TopCount( [Geography].[Geo].[Country].members, 3, [Measures].[Amount] )

SELECT [my-top-2010-countries] ON 0

FROM [sales]
WHERE [2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### STATIC Evaluation

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example is creating a set of countries having [Corporate] license sales and then select them according to the [Personal] license.

**Query**

```
WITH STATIC SET [my-countries] AS Filter( [Geography].[Geo].[Country].members, ([Measures].[Amount], [Product].[Prod].[Article].[icCube].[Corporate] ) > 0)

SELECT NON EMPTY [my-countries] ON 0

FROM [sales]
WHERE [Product].[Prod].[Article].[icCube].[Personal]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT [Geography].[Geo].[Country].[Switzerland] ON 0
FROM [Sales]
WHERE [Product].[Prod].[Article].[icCube].[Personal]
```


 
</div>

                                                                                                            

### See Also


[Create (Set)](Create%20(Set).md)

[Drop (Set)](Drop%20(Set).md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
