## SetProperty

Sets the property for a measure


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |measure |one | |
| |string |one | |
| |numeric-expression |one | |



### Return

```
member
```



### Description

Sets the property for a measure defined by the second parameter using the third parameter:

<pre>
[Measure].[Amount].setProperty("fx",true)    // set the 'fx' property to true for the [Amount] measure
</pre>

The setProperty function returns the measure member so it can be chained.

This function is mainly used in a script definition using the 'ic3run expr' statement:

<pre>
ic3run expr [Measures].[Amount].setProperty("fx",true);
</pre>

note that the 'ic3run expr' statement must finish by a semi-colon character (;).



### Since Version

6.8.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetProperty(measure,key,value) - boolean

</div>

<div class="ic3-mdx-example-body" style="display:none">

Defines the property defined by the key and value.

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx",true).getProperty("fx",TYPED)
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS true
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetProperty(measure,key,value) - numeric

</div>

<div class="ic3-mdx-example-body" style="display:none">

Defines the property defined by the key and value.

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx",1.5).getProperty("fx",TYPED)
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td>1.5</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS 1.5
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetProperty(measure,key,value) - string

</div>

<div class="ic3-mdx-example-body" style="display:none">

Defines the property defined by the key and value.

**Query**

```
WITH
    MEMBER [Measures].[Fx Prop] AS [Measures].[Amount].setProperty("fx","Got it !").getProperty("fx")
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Fx Prop</td>
</tr>
<tr>
 <td>Got it !</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Fx Prop] AS "Got it !"
SELECT
    [Measures].[Fx Prop] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[GetProperty](GetProperty.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
