## SetAxes

Set Axis to a Matrix or Vector.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|matrix/vector |expression |one | |
|axis |set-expression |one-n | |



### Return

```
value
```



### Description

This function allows for setting the axis to an existing Matrix or Vector. It can also be used for resetting the axis of a MatrixA or VectorA.

Matrix().setAxis( [Countries].members, [Years].members ), will return a MatrixA with the new defined sets.
Vector().setAxis( [Countries].members ), will return a VectorA with the new defined sets.

This method will return an error if the sets have not the same size as the one of defined by the Matrix of Vector.



### Since Version

4.8


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetAxes(set,set) - Matrix

</div>

<div class="ic3-mdx-example-body" style="display:none">

Allow for setting the Axes to a Matrix.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS Matrix( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] ).setAxes( [Geography].[Geo].[Country], [Product].[Prod].[Licence] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>768.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>144.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>96.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>4.0</td>
 <td>3.0</td>
 <td>8.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
 <td>0.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] ).setAxes( [Geography].[Geo].[Country], [Product].[Prod].[Licence] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetAxes(set) - Vector

</div>

<div class="ic3-mdx-example-body" style="display:none">

Allow for setting the Axes to a Vector.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS Vector( [Geography].[Geo].[Country], [Measures].[Amount], INCLUDEEMPTY ).setAxes( [Geography].[Geo].[Country] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">matrix-a</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>0.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3.0</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount], INCLUDEEMPTY )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```


**Assertion : Cell Equals**

```
WITH
  MEMBER [Measures].[matrix-a] AS VectorA( [Geography].[Geo].[Country], [Measures].[Amount], INCLUDEEMPTY ).setAxes( [Geography].[Geo].[Country] )
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]                    
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetAxes(set,set) - Matrix Size Error

</div>

<div class="ic3-mdx-example-body" style="display:none">

SetAxes generates a cell on error if the Axes have not the expected matrix size.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS Matrix( [Geography].[Geo].[Country], [Product].[Prod].[Licence], [Measures].[Amount] ).setAxes( [Product].[Prod].[Licence], [Geography].[Geo].[Country] )
SELECT
  [Measures].[matrix-a] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">matrix-a</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_MATRIX_ERROR)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_MATRIX_ERROR](icCubeError.md#olap_matrix_error)<br>Error Message : SetAxes() : First set - cols - size '4' does not match matrix column size '7'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SetAxes(set) - Vector Size Error

</div>

<div class="ic3-mdx-example-body" style="display:none">

SetAxes generates a cell on error if the Axes have not the expected vector size.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS Vector( [Geography].[Geo].[Country], [Measures].[Amount] ).setAxes( [Product].[Prod].[Licence] )
SELECT
  [Measures].[matrix-a] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">matrix-a</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_VECTOR_ERROR)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_VECTOR_ERROR](icCubeError.md#olap_vector_error)<br>Error Message : SetAxes() : Set size '4' does not match Vector size '7'</pre>


 
</div>

                                                                         

### See Also


[MatrixA](MatrixA.md)

[VectorA](VectorA.md)

[Matrix](Matrix.md)

[Vector](Vector.md)

[ElementValue](ElementValue.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
