## SchemaUpdateTime

Returns the update time of the current schema.



### Return

```
date
```



### Description

This function returns the update time (that is the time of the last data changed) of the current schema as an MDX Date.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SchemaUpdateTime()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the schema's update time/date.

**Query**

```
WITH
 MEMBER [timestamp] AS SchemaUpdateTime()
SELECT
  timestamp on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">timestamp</td>
</tr>
<tr>
 <td>2025-11-21T09:28:15.242</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
 MEMBER timestamp AS SchemaUpdateTime()
SELECT
  {timestamp} on 0
 FROM [SALES]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SchemaUpdateTime() : output format

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the schema's update time/date and use the FORMAT_STRING property to display hours/minutes only.

**Query**

```
WITH
 MEMBER [timestamp] AS SchemaUpdateTime(), FORMAT_STRING = "j:HH'h'mm"
SELECT
  timestamp on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">timestamp</td>
</tr>
<tr>
 <td>09h28</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
 MEMBER timestamp AS SchemaUpdateTime(), FORMAT_STRING = "j:HH'h'mm"
SELECT
  {timestamp} on 0
 FROM [SALES]
```


 
</div>

                                                                                                            

### See Also


[SchemaRefreshTime](SchemaRefreshTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
