## SchemaRefreshTime

Returns the refresh time of the current schema.



### Return

```
date
```



### Description

This function returns the refresh time (that is the end time of the last (incr.) load request) of the current schema as an MDX Date.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SchemaRefreshTime()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the schema's refresh time/date.

**Query**

```
WITH
 MEMBER [timestamp] AS SchemaRefreshTime()
SELECT
  timestamp on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">timestamp</td>
</tr>
<tr>
 <td>2025-11-21T09:28:15.298</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
 MEMBER timestamp AS SchemaRefreshTime()
SELECT
  {timestamp} on 0
 FROM [SALES]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### SchemaRefreshTime() : output format

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the schema's refresh time/date and use the FORMAT_STRING property to display hours/minutes only.

**Query**

```
WITH
 MEMBER [timestamp] AS SchemaRefreshTime(), FORMAT_STRING = "j:HH'h'mm"
SELECT
  timestamp on 0
 FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">timestamp</td>
</tr>
<tr>
 <td>09h28</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
 MEMBER timestamp AS SchemaRefreshTime(), FORMAT_STRING = "j:HH'h'mm"
SELECT
  {timestamp} on 0
 FROM [SALES]
```


 
</div>

                                                                                                            

### See Also


[SchemaUpdateTime](SchemaUpdateTime.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
