## RGB

Create a color from its RGB values.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|red |value-expression |one | |
|green |value-expression |one | |
|value |value-expression |one | |



### Return

```
color
```



### Description

The function returns a color in the RGB color space; e.g., red-color = RGB( 255, 0, 0).

Note that the RGB accepts a string representing the RGB components in hexadecimal value as parameter: e.g., red-color = RGB("#FF0000").

Note that the input string is following CSS syntax, that is #123 is converted to #112233.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### RGB( r, g, b)

</div>

<div class="ic3-mdx-example-body" style="display:none">

This examples creates the red color.

**Query**

```
WITH
    MEMBER [Measures].[RED] AS RGB( 255, 0, 0 )
SELECT
    [Measures].[RED] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">RED</td>
</tr>
<tr>
 <td>255</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[RED] AS 255
SELECT
    [Measures].[RED] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### RGB( '#rrggbb' )

</div>

<div class="ic3-mdx-example-body" style="display:none">

This examples creates the red color from its hexadecimal string.

**Query**

```
WITH
    MEMBER [Measures].[RED] AS RGB( "#FF0000" )
SELECT
    [Measures].[RED] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">RED</td>
</tr>
<tr>
 <td>255</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[RED] AS 255
SELECT
    [Measures].[RED] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[HSV](HSV.md)

[InterpolateRGBColors](InterpolateRGBColors.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
